/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import java.util.function.Function;
import org.skr.common.util.JsonUtil;
import org.skr.common.util.JwtUtil;
import org.skr.security.SkrSecurityProperties;
import org.skr.security.UserPrincipal;

public final class Token {
    private final String header;
    private final UserPrincipal principal;
    private final String prefix;
    private final long expiration;
    private final String secret;

    public static Token of(SkrSecurityProperties.Token tokenProp, UserPrincipal principal) {
        return Token.of(tokenProp.getHeader(), principal, tokenProp.getPrefix(), tokenProp.getExpiration(), tokenProp.getSecret());
    }

    public String encode() {
        return this.prefix + JwtUtil.encode(JsonUtil.toJson(this.principal), this.expiration, this.secret);
    }

    public String encodeIdentity() {
        return this.prefix + JwtUtil.encode(this.principal.getIdentity(), this.expiration, this.secret);
    }

    public String encode(Function<Token, String> payloadGenerator) {
        return this.prefix + JwtUtil.encode(payloadGenerator.apply(this), this.expiration, this.secret);
    }

    public String getHeader() {
        return this.header;
    }

    public UserPrincipal getPrincipal() {
        return this.principal;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        if (this.getExpiration() != other.getExpiration()) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        UserPrincipal this$principal = this.getPrincipal();
        UserPrincipal other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        return !(this$secret == null ? other$secret != null : !this$secret.equals(other$secret));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expiration = this.getExpiration();
        result = result * 59 + (int)($expiration >>> 32 ^ $expiration);
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        UserPrincipal $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        return result;
    }

    public String toString() {
        return "Token(header=" + this.getHeader() + ", principal=" + this.getPrincipal() + ", prefix=" + this.getPrefix() + ", expiration=" + this.getExpiration() + ", secret=" + this.getSecret() + ")";
    }

    private Token(String header, UserPrincipal principal, String prefix, long expiration, String secret) {
        this.header = header;
        this.principal = principal;
        this.prefix = prefix;
        this.expiration = expiration;
        this.secret = secret;
    }

    public static Token of(String header, UserPrincipal principal, String prefix, long expiration, String secret) {
        return new Token(header, principal, prefix, expiration, secret);
    }
}

