/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import jakarta.validation.ConstraintViolation;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.skr.common.exception.ErrorInfo;

public final class Checker {
    private Checker() {
    }

    public static boolean isZero(Long longNum) {
        return longNum == null || longNum == 0L;
    }

    public static boolean isZero(Optional<Long> longNum) {
        return longNum == null || longNum.isEmpty() || longNum.get() == 0L;
    }

    public static boolean isZero(Integer integer) {
        return integer == null || integer == 0;
    }

    public static boolean isZero(Double doubleNum) {
        return doubleNum == null || doubleNum == 0.0;
    }

    public static boolean isPositive(Integer integer) {
        return integer != 0 && integer > 0;
    }

    public static boolean isEmpty(CharSequence text) {
        return text == null || text.length() <= 0 || "null".contentEquals(text);
    }

    public static boolean isEmpty(Optional<? extends CharSequence> text) {
        return text.isEmpty() || Checker.isEmpty(text.get());
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isExistedFile(File file) {
        return file != null && file.exists();
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(File file) {
        return file == null || !file.exists() || file.length() <= 0L;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmptyCollection(Optional<? extends Collection> collection) {
        return collection.isEmpty() || collection.get().isEmpty();
    }

    public static boolean isEmpty(Iterable iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean containsKey(Map map, Object key) {
        return map != null && map.containsKey(key);
    }

    public static boolean isEmpty(Date date) {
        return date == null || date.getTime() == 0L;
    }

    public static boolean isDeleted(Boolean deleted) {
        return deleted != null && deleted != false;
    }

    public static boolean isAfterOrEqual(LocalDateTime dt1, LocalDateTime dt2) {
        return dt1.isEqual(dt2) || dt1.isAfter(dt2);
    }

    public static boolean isBeforeOrEqual(LocalDateTime dt1, LocalDateTime dt2) {
        return dt1.isEqual(dt2) || dt1.isBefore(dt2);
    }

    public static boolean isNumber(String str) {
        return str.matches("\\d+");
    }

    public static boolean isTrue(String boolStr) {
        if (Checker.isEmpty(boolStr)) {
            return false;
        }
        return "1".equals(boolStr) || "true".equals(boolStr);
    }

    public static boolean isTrue(Boolean bool) {
        return bool != null && bool != false;
    }

    public static boolean isTrue(Optional<Boolean> bool) {
        return bool != null && bool.isPresent() && bool.get() != false;
    }

    public static <T> List<ErrorInfo> convertViolationsToErrorInfo(Set<ConstraintViolation<T>> violations) {
        if (Checker.isEmpty(violations)) {
            return new ArrayList<ErrorInfo>();
        }
        return violations.stream().map(violation -> ErrorInfo.INVALID_SUBMITTED_DATA.extra("path", violation.getPropertyPath().toString()).msgArgs(violation.getMessage())).collect(Collectors.toList());
    }

    public static boolean equalsAndNotNull(Object lhs, Object rhs) {
        return lhs != null && rhs != null && Objects.equals(lhs, rhs);
    }
}

