/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import jakarta.persistence.Transient;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import org.laxture.spring.util.ApplicationContextProvider;
import org.skr.config.json.ExtendableLocalDateTimeDeserializer;
import org.skr.config.json.JsonSkipPersistence;
import org.skr.config.json.ValuedEnumModule;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class JsonUtil {
    public static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = (ObjectMapper)ApplicationContextProvider.getBean(ObjectMapper.class);
        if (objectMapper == null) {
            objectMapper = Jackson2ObjectMapperBuilder.json().build();
            JsonUtil.setupObjectMapper(objectMapper);
        }
        return objectMapper;
    }

    public static ObjectMapper setupObjectMapper(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.registerModule((Module)new ValuedEnumModule());
        objectMapper.configure(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS, false);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)ExtendableLocalDateTimeDeserializer.INSTANCE);
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        objectMapper.registerModule((Module)javaTimeModule);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY));
        return objectMapper;
    }

    public static ObjectMapper setupPersistentObjectMapper(ObjectMapper objectMapper) {
        return objectMapper.copy().configure(MapperFeature.REQUIRE_SETTERS_FOR_GETTERS, true).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return this._hasOneOf((Annotated)m, new Class[]{JsonSkipPersistence.class, JsonIgnore.class, java.beans.Transient.class, Transient.class, org.springframework.data.annotation.Transient.class});
            }
        });
    }

    public static <T> T fromJson(Class<?> type, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, json);
    }

    public static <T> T fromJson(TypeReference<T> type, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, json);
    }

    public static <T> T fromJson(JavaType javaType, String json) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), javaType, json);
    }

    public static <T> T fromJson(Class<?> type, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, jsonNode);
    }

    public static <T> T fromJson(TypeReference<T> type, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), type, jsonNode);
    }

    public static <T> T fromJson(JavaType javaType, JsonNode jsonNode) {
        return JsonUtil.fromJson(JsonUtil.getObjectMapper(), javaType, jsonNode);
    }

    public static String toJson(Object obj, Class<?> jsonViewClazz) {
        return JsonUtil.toJson(JsonUtil.getObjectMapper(), obj, jsonViewClazz);
    }

    public static String toJson(Object obj) {
        return JsonUtil.toJson(JsonUtil.getObjectMapper(), obj);
    }

    public static JsonNode toJsonNode(Object obj) {
        return JsonUtil.toJsonNode(JsonUtil.getObjectMapper(), obj);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, Class<?> type, String json) {
        if (json == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, TypeReference<T> type, String json) {
        if (json == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, JavaType javaType, String json) {
        if (json == null) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new RuntimeException("Deserialize json text failed. " + json, e);
        }
    }

    public static <T> T fromJson(ObjectMapper objectMapper, Class<?> type, JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        return (T)objectMapper.convertValue((Object)jsonNode, type);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, TypeReference<T> type, JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        return (T)objectMapper.convertValue((Object)jsonNode, type);
    }

    public static <T> T fromJson(ObjectMapper objectMapper, JavaType javaType, JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        return (T)objectMapper.convertValue((Object)jsonNode, javaType);
    }

    public static String toJson(ObjectMapper objectMapper, Object obj, Class<?> jsonViewClazz) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writerWithView(jsonViewClazz).writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static String toJson(ObjectMapper objectMapper, Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static JsonNode toJsonNode(ObjectMapper objectMapper, Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return objectMapper.valueToTree(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Serialize object<" + obj.getClass().getName() + "> to json failed.", e);
        }
    }

    public static JavaType getJavaType(Class<?> clazz) {
        return JsonUtil.getObjectMapper().getSerializationConfig().getTypeFactory().constructType(clazz);
    }

    public static JavaType getCollectionJavaType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return JsonUtil.getObjectMapper().getSerializationConfig().getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }
}

