/*
 * Decompiled with CFR 0.152.
 */
package org.skr.config;

import java.time.Duration;
import org.skr.SkrProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.context.MessageSourceProperties;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class EnumLabelMessageSource
extends ResourceBundleMessageSource
implements InitializingBean {
    @Autowired(required=false)
    private MessageSourceProperties messageSourceProperties;
    @Autowired
    private SkrProperties skrProperties;

    public void afterPropertiesSet() {
        if (this.messageSourceProperties == null) {
            this.messageSourceProperties = new MessageSourceProperties();
        }
        if (StringUtils.hasText((String)this.skrProperties.getEnumLabelPropBasename())) {
            this.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.skrProperties.getEnumLabelPropBasename())));
        }
        if (this.messageSourceProperties.getEncoding() != null) {
            this.setDefaultEncoding(this.messageSourceProperties.getEncoding().name());
        }
        this.setFallbackToSystemLocale(this.messageSourceProperties.isFallbackToSystemLocale());
        Duration cacheDuration = this.messageSourceProperties.getCacheDuration();
        if (cacheDuration != null) {
            this.setCacheMillis(cacheDuration.toMillis());
        }
        this.setAlwaysUseMessageFormat(this.messageSourceProperties.isAlwaysUseMessageFormat());
        this.setUseCodeAsDefaultMessage(this.messageSourceProperties.isUseCodeAsDefaultMessage());
    }
}

