/*
 * Decompiled with CFR 0.152.
 */
package org.skr.config.json;

import java.lang.reflect.Method;
import java.util.Objects;
import org.laxture.spring.util.ApplicationContextProvider;
import org.skr.common.exception.ConfException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.util.BeanUtil;
import org.skr.config.EnumLabelMessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public interface ValuedEnum<V> {
    public V value();

    default public String enumLabel() {
        try {
            return ((EnumLabelMessageSource)((Object)ApplicationContextProvider.getBean(this.getClass(), EnumLabelMessageSource.class))).getMessage(this.getClass().getSimpleName(), null, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException ex) {
            return this.getClass().getSimpleName();
        }
    }

    default public String valueLabel() {
        try {
            return ((EnumLabelMessageSource)((Object)ApplicationContextProvider.getBean(this.getClass(), EnumLabelMessageSource.class))).getMessage(this.getClass().getSimpleName() + "." + this.value().toString(), null, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException ex) {
            return this.getClass().getSimpleName();
        }
    }

    public static <E extends ValuedEnum<V>, V> E parse(E[] values, V value, E defaultItem) {
        for (E item : values) {
            if (!Objects.equals(item.value(), value)) continue;
            return item;
        }
        return defaultItem;
    }

    public static <E extends ValuedEnum<V>, V> E parse(Class<?> enumType, V value) {
        if (value == null) {
            return null;
        }
        Method parseMethod = BeanUtil.getMethod(enumType, "parse", value.getClass());
        if (parseMethod == null) {
            parseMethod = BeanUtil.getMethod(enumType, "parse", BeanUtil.PRIMITIVE_TYPES.get(value.getClass()));
        }
        if (parseMethod == null) {
            throw new ConfException(ErrorInfo.PARSE_METHOD_NOT_FOUND.msgArgs(value.getClass().getSimpleName(), enumType.getSimpleName()));
        }
        try {
            return (E)((ValuedEnum)parseMethod.invoke((Object)parseMethod, value));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
    }
}

