/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.Optional;
import org.skr.common.exception.AuthException;
import org.skr.common.exception.ConfException;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.util.Checker;
import org.skr.common.util.JsonUtil;
import org.skr.common.util.JwtUtil;
import org.skr.common.util.tuple.Tuple2;
import org.skr.security.GhostJwtPrincipal;
import org.skr.security.JwtPrincipal;
import org.skr.security.SkrSecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class JwtAuthenticationToken
extends AbstractAuthenticationToken {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationToken.class);
    private static final long serialVersionUID = 5139007837781843747L;
    private final JwtPrincipal principal;

    public JwtAuthenticationToken(@NotNull JwtPrincipal principal) {
        super(Collections.emptyList());
        this.principal = principal;
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getName() {
        return this.principal.getIdentity();
    }

    public static Authentication authenticate(String accessToken, SkrSecurityProperties properties) {
        if (Checker.isEmpty(accessToken)) {
            throw new AuthException(ErrorInfo.ACCESS_TOKEN_NOT_PROVIDED);
        }
        try {
            Authentication authentication = JwtAuthenticationToken.getAuthentication(accessToken, properties);
            if (!authentication.isAuthenticated()) {
                throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
            }
            SecurityContextHolder.getContext().setAuthentication(authentication);
            return authentication;
        }
        catch (TokenExpiredException ex) {
            throw new AuthException(ErrorInfo.ACCESS_TOKEN_EXPIRED);
        }
        catch (JWTVerificationException ex) {
            throw new AuthException(ErrorInfo.ACCESS_TOKEN_BROKEN);
        }
        catch (Exception ex) {
            throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
        }
    }

    public static Authentication getAuthentication(String accessToken, SkrSecurityProperties properties) {
        if (accessToken.startsWith(properties.getAccessToken().getPrefix())) {
            String prefix = properties.getAccessToken().getPrefix();
            String secret = properties.getAccessToken().getSecret();
            if (properties.getJwtPrincipalClass() == null) {
                throw new ConfException(ErrorInfo.MISSING_PROPERTY.msgArgs("spring.skr.security.jwtPrincipalClass"));
            }
            return Optional.of(accessToken).map(token -> token.replace(prefix, "")).map(token -> new Tuple2<String, String>(JwtUtil.decode(token, secret), (String)token)).map(decodedTuple -> {
                JwtPrincipal principal = (JwtPrincipal)JsonUtil.fromJson(properties.getJwtPrincipalClass(), (String)decodedTuple._0());
                return new JwtAuthenticationToken(principal);
            }).orElse(null);
        }
        if (accessToken.startsWith(properties.getGhostToken().getPrefix())) {
            String prefix = properties.getGhostToken().getPrefix();
            String secret = properties.getGhostToken().getSecret();
            return Optional.of(accessToken).map(token -> token.replace(prefix, "")).map(token -> new Tuple2<String, String>(JwtUtil.decode(token, secret), (String)token)).map(decodedTuple -> {
                JwtPrincipal principal = (JwtPrincipal)JsonUtil.fromJson(GhostJwtPrincipal.class, (String)decodedTuple._0());
                return new JwtAuthenticationToken(principal);
            }).orElse(null);
        }
        throw new AuthException(ErrorInfo.AUTHENTICATION_REQUIRED);
    }
}

