/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.exception;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.laxture.spring.util.ApplicationContextProvider;
import org.skr.common.exception.BaseException;
import org.skr.common.exception.ConfException;
import org.skr.common.util.Checker;
import org.skr.config.ErrorMessageSource;
import org.skr.config.json.ValuedEnum;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class ErrorInfo
implements Serializable,
Cloneable {
    @NotNull
    private int code;
    @NotNull
    private String msg;
    private ErrorLevel level = ErrorLevel.ERROR;
    private Object[] args;
    private String exception;
    private Map<String, Object> extra;
    private boolean shared = true;
    private ClassLoader classLoader;
    public static final ErrorInfo OK = ErrorInfo.of(0, null);
    public static final ErrorInfo INTERNAL_SERVER_ERROR = ErrorInfo.of(1001, "error.INTERNAL_SERVER_ERROR", ErrorLevel.FATAL);
    public static final ErrorInfo ENTITY_NOT_FOUND = ErrorInfo.of(1002, "error.ENTITY_NOT_FOUND");
    public static final ErrorInfo DELETION_RESTRICTED = ErrorInfo.of(1003, "error.DELETION_RESTRICTED");
    public static final ErrorInfo INVALID_SUBMITTED_DATA = ErrorInfo.of(1004, "error.INVALID_SUBMITTED_DATA");
    public static final ErrorInfo INVALID_SERVER_DATA = ErrorInfo.of(1005, "error.INVALID_SERVER_DATA");
    public static final ErrorInfo SAVE_DATA_FAILED = ErrorInfo.of(1006, "error.SAVE_DATA_FAILED");
    public static final ErrorInfo DUPLICATED_ENTITY = ErrorInfo.of(1007, "error.DUPLICATED_ENTITY");
    public static final ErrorInfo INCOMPATIBLE_TYPE = ErrorInfo.of(1010, "error.INCOMPATIBLE_TYPE", ErrorLevel.FATAL);
    public static final ErrorInfo METHOD_NOT_FOUND = ErrorInfo.of(1014, "error.METHOD_NOT_FOUND", ErrorLevel.FATAL);
    public static final ErrorInfo FIELD_NOT_FOUND = ErrorInfo.of(1015, "error.FIELD_NOT_FOUND", ErrorLevel.FATAL);
    public static final ErrorInfo MISSING_PROPERTY = ErrorInfo.of(1009, "error.MISSING_PROPERTY", ErrorLevel.FATAL);
    public static final ErrorInfo MISSING_ARGUMENT = ErrorInfo.of(1016, "error.MISSING_ARGUMENT", ErrorLevel.FATAL);
    public static final ErrorInfo PARSE_METHOD_NOT_FOUND = ErrorInfo.of(1017, "error.PARSE_METHOD_NOT_FOUND", ErrorLevel.FATAL);
    public static final ErrorInfo INVALID_CONFIGURATION = ErrorInfo.of(1019, "error.INVALID_CONFIGURATION", ErrorLevel.FATAL);
    public static final ErrorInfo BAD_IMPLEMENTATION = ErrorInfo.of(1020, "error.BAD_IMPLEMENTATION", ErrorLevel.FATAL);
    public static final ErrorInfo AUTHENTICATION_REQUIRED = ErrorInfo.of(1100, "error.AUTHENTICATION_REQUIRED");
    public static final ErrorInfo BAD_CERTIFICATION = ErrorInfo.of(1101, "error.BAD_CERTIFICATION");
    public static final ErrorInfo ACCESS_TOKEN_EXPIRED = ErrorInfo.of(1102, "error.ACCESS_TOKEN_EXPIRED");
    public static final ErrorInfo ACCESS_TOKEN_BROKEN = ErrorInfo.of(1103, "error.ACCESS_TOKEN_BROKEN");
    public static final ErrorInfo ACCESS_TOKEN_NOT_PROVIDED = ErrorInfo.of(1104, "error.ACCESS_TOKEN_NOT_PROVIDED");
    public static final ErrorInfo REFRESH_TOKEN_EXPIRED = ErrorInfo.of(1105, "error.REFRESH_TOKEN_EXPIRED");
    public static final ErrorInfo REFRESH_TOKEN_BROKEN = ErrorInfo.of(1106, "error.REFRESH_TOKEN_BROKEN");
    public static final ErrorInfo PERMISSION_DENIED = ErrorInfo.of(1107, "error.PERMISSION_DENIED");
    public static final ErrorInfo PERMISSION_LIMITED = ErrorInfo.of(1108, "error.PERMISSION_LIMITED", ErrorLevel.FATAL);
    public static final ErrorInfo PERMISSION_NOT_FOUND = ErrorInfo.of(1109, "error.PERMISSION_NOT_FOUND", ErrorLevel.FATAL);
    public static final ErrorInfo CERTIFICATION_NOT_FOUND = ErrorInfo.of(1110, "error.CERTIFICATION_NOT_FOUND");
    public static final ErrorInfo CERTIFICATION_REGISTERED = ErrorInfo.of(1111, "error.CERTIFICATION_REGISTERED");
    public static final ErrorInfo LAST_CERTIFICATION = ErrorInfo.of(1112, "error.LAST_CERTIFICATION");
    public static final ErrorInfo CLIENT_IP_NOT_ALLOWED = ErrorInfo.of(1100, "error.CLIENT_IP_NOT_ALLOWED");
    public static final ErrorInfo REALM_NOT_REGISTERED = ErrorInfo.of(1200, "error.REALM_NOT_REGISTERED", ErrorLevel.FATAL);
    public static final ErrorInfo REGISTER_REGISTRY_FAILED = ErrorInfo.of(1202, "error.REGISTER_REGISTRY_FAILED", ErrorLevel.FATAL);
    public static final ErrorInfo UNREGISTER_REGISTRY_FAILED = ErrorInfo.of(1203, "error.UNREGISTER_REGISTRY_FAILED", ErrorLevel.FATAL);
    public static final ErrorInfo UNINSTALL_REGISTRY_FAILED = ErrorInfo.of(1204, "error.UNINSTALL_REGISTRY_FAILED", ErrorLevel.FATAL);

    public static ErrorInfo of(int code, String msg) {
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.code = code;
        errorInfo.msg = msg;
        return errorInfo;
    }

    public static ErrorInfo of(int code, String msg, ErrorLevel level) {
        ErrorInfo errorInfo = ErrorInfo.of(code, msg);
        errorInfo.level = level;
        return errorInfo;
    }

    public static ErrorInfo of(int code, String msg, ErrorLevel level, ClassLoader classLoader) {
        ErrorInfo errorInfo = ErrorInfo.of(code, msg, level);
        errorInfo.classLoader = classLoader;
        return errorInfo;
    }

    public static ErrorInfo fromJsr303(Class<?> annotation) {
        if (!annotation.getName().startsWith("jakarta.validation.constraints")) {
            throw new ConfException(INVALID_CONFIGURATION.msgArgs("Only accept jakarta.validation.constraints.* annotations"));
        }
        return ErrorInfo.of(INVALID_SUBMITTED_DATA.getCode(), annotation.getName() + ".message");
    }

    private static ErrorInfo getOrCopy(@NonNull ErrorInfo target) {
        ErrorInfo errorInfo;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.shared) {
            errorInfo = target.clone();
            errorInfo.shared = false;
        } else {
            errorInfo = target;
        }
        return errorInfo;
    }

    public ErrorInfo exception(Throwable ex) {
        ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
        errorInfo.exception = BaseException.getStackTrace(ex);
        return errorInfo;
    }

    public ErrorInfo msgArgs(Object ... args) {
        ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
        errorInfo.args = args;
        return errorInfo;
    }

    public ErrorInfo extra(String key, Object value) {
        return this.extra(key, value, true);
    }

    public ErrorInfo extra(String key, Object value, boolean shouldBeAdded) {
        if (shouldBeAdded) {
            ErrorInfo errorInfo = ErrorInfo.getOrCopy(this);
            if (errorInfo.extra == null) {
                errorInfo.extra = new HashMap<String, Object>();
            }
            errorInfo.extra.put(key, value);
            return errorInfo;
        }
        return this;
    }

    @JsonProperty(value="ec")
    public int getCode() {
        return this.code;
    }

    @JsonProperty(value="msg")
    public String getMsg() {
        ClassLoader classLoader = Optional.ofNullable(this.classLoader).orElse(this.getClass().getClassLoader());
        try {
            ErrorMessageSource msgSource = (ErrorMessageSource)((Object)ApplicationContextProvider.getBean((ClassLoader)classLoader, ErrorMessageSource.class));
            if (msgSource == null) {
                return this.msg;
            }
            return msgSource.getMessage(this.msg, this.args, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException ex) {
            return this.msg;
        }
    }

    @JsonProperty(value="elv")
    public ErrorLevel getLevel() {
        return this.level;
    }

    @JsonProperty(value="ex")
    public String getException() {
        return this.exception;
    }

    @JsonProperty(value="extra")
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public <T> T getExtra(String key) {
        if (Checker.isEmpty(this.extra)) {
            return null;
        }
        return (T)this.extra.get(key);
    }

    public static ErrorLevel worstErrorLevel(List<ErrorInfo> errors) {
        if (Checker.isEmpty(errors)) {
            return null;
        }
        return errors.stream().map(ErrorInfo::getLevel).filter(level -> level == ErrorLevel.FATAL).findAny().orElse(errors.stream().map(ErrorInfo::getLevel).filter(level -> level == ErrorLevel.ERROR).findAny().orElse(ErrorLevel.WARNING));
    }

    public String getMessage() {
        Object fieldName = (String)this.getExtra("fieldName");
        if (fieldName == null) {
            fieldName = (String)this.getExtra("path");
        }
        fieldName = fieldName != null ? (String)fieldName + ": " : "";
        return (String)fieldName + this.getMsg();
    }

    public ErrorInfo clone() {
        try {
            return (ErrorInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "ErrorInfo(code=" + this.getCode() + ", msg=" + this.getMsg() + ", level=" + this.getLevel() + ", args=" + Arrays.deepToString(this.args) + ", exception=" + this.getException() + ", extra=" + this.getExtra() + ", shared=" + this.shared + ", classLoader=" + this.classLoader + ")";
    }

    public static enum ErrorLevel implements ValuedEnum<String>
    {
        WARNING("warn"),
        ERROR("error"),
        FATAL("fatal");

        private final String value;

        private ErrorLevel(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static ErrorLevel parse(String value) {
            return (ErrorLevel)ValuedEnum.parse((ValuedEnum[])ErrorLevel.values(), (Object)value, (ValuedEnum)FATAL);
        }
    }
}

