/*
 * Decompiled with CFR 0.152.
 */
package org.skr;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.skr.SkrProperties;
import org.skr.common.util.JsonUtil;
import org.skr.config.EnumLabelMessageSource;
import org.skr.config.ErrorMessageSource;
import org.skr.config.ExceptionFormatter;
import org.skr.config.GeneralExceptionHandler;
import org.skr.security.SkrSecurityProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties
@Import(value={SkrSecurityProperties.class, SkrProperties.class, GeneralExceptionHandler.class, EnumLabelMessageSource.class, ErrorMessageSource.class})
public class SkrConfig {
    @Bean
    @ConditionalOnMissingBean
    public KeyGenerator keyGenerator() {
        return (target, method, params) -> {
            String targetClass = method.getDeclaringClass().getName();
            String methodPrefix = targetClass + "." + method.getName() + "\u2206";
            return methodPrefix + Arrays.stream(params).map(param -> {
                if (param == null) {
                    return "null";
                }
                if (param.getClass().isArray()) {
                    return "array";
                }
                return param.toString();
            }).collect(Collectors.joining("\u2206"));
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionFormatter exceptionFormatter() {
        return new ExceptionFormatter();
    }

    @Configuration
    @AutoConfigureAfter(value={JacksonAutoConfiguration.class})
    public static class JacksonConfigurer
    implements InitializingBean {
        @Autowired
        private ObjectMapper objectMapper;

        public void afterPropertiesSet() {
            JsonUtil.setupObjectMapper(this.objectMapper);
        }
    }
}

