/*
 * Decompiled with CFR 0.152.
 */
package org.skr.common.exception;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.stream.Collectors;
import org.skr.common.exception.ErrorInfo;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 2607643356290543387L;
    private final List<ErrorInfo> errorInfos;

    public ValidationException(@NotNull ErrorInfo errorInfo) {
        super(errorInfo.getMessage());
        this.errorInfos = List.of(errorInfo);
    }

    public ValidationException(@NotEmpty List<ErrorInfo> errorInfos) {
        super(errorInfos.stream().map(ErrorInfo::getMessage).collect(Collectors.joining("\n")));
        this.errorInfos = errorInfos;
    }

    public List<ErrorInfo> getErrorInfos() {
        return this.errorInfos;
    }

    public ErrorInfo.ErrorLevel worstErrorLevel() {
        return ErrorInfo.worstErrorLevel(this.errorInfos);
    }
}

