/*
 * Decompiled with CFR 0.152.
 */
package org.skr.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.laxture.spring.util.ApplicationContextProvider;
import org.skr.security.GhostJwtPrincipal;
import org.skr.security.SkrSecurityProperties;
import org.skr.security.Token;
import org.skr.security.UserPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public interface JwtPrincipal
extends UserPrincipal {
    @JsonIgnore
    public Boolean isGhost();

    @JsonIgnore
    default public String getChainAccessToken() {
        SkrSecurityProperties skrSecurityProperties = (SkrSecurityProperties)ApplicationContextProvider.getBean(SkrSecurityProperties.class);
        return this.isGhost() != false ? Token.of(skrSecurityProperties.getAccessToken().getHeader(), GhostJwtPrincipal.of(skrSecurityProperties.getGhostUserName()), skrSecurityProperties.getGhostToken().getPrefix(), skrSecurityProperties.getGhostToken().getExpiration(), skrSecurityProperties.getGhostToken().getSecret()).encode() : Token.of(skrSecurityProperties.getAccessToken().getHeader(), this, skrSecurityProperties.getAccessToken().getPrefix(), 0L, skrSecurityProperties.getAccessToken().getSecret()).encode();
    }

    public static Optional<JwtPrincipal> getCurrentPrincipal() {
        return Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).filter(Authentication::isAuthenticated).map(Authentication::getPrincipal).filter(principal -> principal instanceof JwtPrincipal).map(principal -> (JwtPrincipal)principal);
    }
}

