/*
 * Decompiled with CFR 0.152.
 */
package org.skr.auth.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.skr.auth.service.CertificationHandler;
import org.skr.common.exception.AuthException;
import org.skr.common.exception.BizException;
import org.skr.common.exception.ErrorInfo;
import org.skr.security.Certification;
import org.skr.security.SkrSecurityProperties;
import org.skr.security.UserPrincipal;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AuthManager {
    @Autowired
    protected SkrSecurityProperties skrSecurityProperties;
    @Autowired
    private List<CertificationHandler> certificationHandlers;

    public final UserPrincipal signUp(UserPrincipal principal, @NonNull Certification certification, Map<String, Object> arguments) {
        if (certification == null) {
            throw new NullPointerException("certification is marked non-null but is null");
        }
        return this.saveCertification(principal, certification, arguments);
    }

    public final UserPrincipal signIn(@NonNull Certification certification, Map<String, Object> arguments) {
        if (certification == null) {
            throw new NullPointerException("certification is marked non-null but is null");
        }
        UserPrincipal principal = this.authenticate(certification, arguments);
        if (principal == null) {
            throw new AuthException(ErrorInfo.CERTIFICATION_NOT_FOUND.msgArgs(new Object[]{certification.getIdentity()}));
        }
        return principal;
    }

    public final void bindCertification(@NonNull Certification boundCertification, @NonNull Certification newCertification, Map<String, Object> arguments) {
        if (boundCertification == null) {
            throw new NullPointerException("boundCertification is marked non-null but is null");
        }
        if (newCertification == null) {
            throw new NullPointerException("newCertification is marked non-null but is null");
        }
        UserPrincipal principal = this.authenticate(boundCertification, arguments);
        if (principal == null) {
            throw new AuthException(ErrorInfo.CERTIFICATION_NOT_FOUND.msgArgs(new Object[]{boundCertification.getIdentity()}));
        }
        this.saveCertification(principal, newCertification, arguments);
    }

    public final void unbindCertification(@NonNull Certification boundCertification, @NonNull Certification removingCertification, Map<String, Object> arguments) {
        if (boundCertification == null) {
            throw new NullPointerException("boundCertification is marked non-null but is null");
        }
        if (removingCertification == null) {
            throw new NullPointerException("removingCertification is marked non-null but is null");
        }
        UserPrincipal principal = this.authenticate(boundCertification, arguments);
        if (principal == null) {
            throw new AuthException(ErrorInfo.CERTIFICATION_NOT_FOUND.msgArgs(new Object[]{boundCertification.getIdentity()}));
        }
        this.removeCertification(principal, removingCertification);
    }

    protected UserPrincipal authenticate(@NonNull Certification certification, Map<String, Object> arguments) {
        if (certification == null) {
            throw new NullPointerException("certification is marked non-null but is null");
        }
        for (CertificationHandler handler : this.certificationHandlers) {
            if (!handler.supports(certification)) continue;
            return handler.authenticate(certification, arguments);
        }
        return null;
    }

    protected UserPrincipal saveCertification(UserPrincipal principal, @NonNull Certification certification, Map<String, Object> arguments) {
        if (certification == null) {
            throw new NullPointerException("certification is marked non-null but is null");
        }
        for (CertificationHandler handler : this.certificationHandlers) {
            if (!handler.supports(certification) || handler.findByIdentity(certification.getIdentity()) == null) continue;
            throw new AuthException(ErrorInfo.CERTIFICATION_REGISTERED.msgArgs(new Object[]{certification.getIdentity()}));
        }
        for (CertificationHandler handler : this.certificationHandlers) {
            if (!handler.supports(certification)) continue;
            return handler.saveCertification(principal, certification, arguments);
        }
        return null;
    }

    protected void removeCertification(@NonNull UserPrincipal principal, @NonNull Certification certification) {
        if (principal == null) {
            throw new NullPointerException("principal is marked non-null but is null");
        }
        if (certification == null) {
            throw new NullPointerException("certification is marked non-null but is null");
        }
        List boundCertifications = this.certificationHandlers.stream().map(handler -> handler.getCertification(principal)).filter(Objects::nonNull).collect(Collectors.toList());
        if (boundCertifications.size() == 1 && Objects.equals(certification.getIdentity(), ((Certification)boundCertifications.get(0)).getIdentity())) {
            throw new BizException(ErrorInfo.LAST_CERTIFICATION.msgArgs(new Object[]{certification.getIdentity()}));
        }
        for (CertificationHandler handler2 : this.certificationHandlers) {
            if (!handler2.supports(certification)) continue;
            handler2.removeCertification(principal, certification.getIdentity());
        }
    }
}

