/*
  $Id: LdapEntryManager.java 2971 2014-04-17 20:28:19Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2971 $
  Updated: $Date: 2014-04-17 16:28:19 -0400 (Thu, 17 Apr 2014) $
*/
package org.ldaptive.beans.persistence;

import org.ldaptive.LdapException;
import org.ldaptive.Response;

/**
 * Interface to manage objects that have been annotated to contain LDAP data.
 *
 * @param  <T>  type of object to manage
 *
 * @author  Middleware Services
 * @version  $Revision: 2971 $ $Date: 2014-04-17 16:28:19 -0400 (Thu, 17 Apr 2014) $
 */
public interface LdapEntryManager<T>
{


  /**
   * Searches for the supplied annotated object in an LDAP and returns the
   * object mapped with it's ldap attribute properties set.
   *
   * @param  object  to find
   *
   * @return  mapped object
   *
   * @throws  LdapException  if the object cannot be found
   */
  T find(T object)
    throws LdapException;


  /**
   * Adds the supplied annotated object to an LDAP.
   *
   * @param  object  to add
   *
   * @return  LDAP response from the add operation
   *
   * @throws  LdapException  if the add fails
   */
  Response<Void> add(T object)
    throws LdapException;


  /**
   * Merges the supplied annotated object in an LDAP. See {@link
   * org.ldaptive.ext.MergeOperation}.
   *
   * @param  object  to merge
   *
   * @return  LDAP response from the merge operation
   *
   * @throws  LdapException  if the merge fails
   */
  Response<Void> merge(T object)
    throws LdapException;


  /**
   * Deletes the supplied annotated object from an LDAP.
   *
   * @param  object  to delete
   *
   * @return  LDAP response from the delete operation
   *
   * @throws  LdapException  if the delete fails
   */
  Response<Void> delete(T object)
    throws LdapException;
}
