/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.persistence;

import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.beans.LdapEntryMapper;
import org.ldaptive.beans.persistence.LdapEntryManager;
import org.ldaptive.ext.MergeOperation;
import org.ldaptive.ext.MergeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapEntryManager<T>
implements LdapEntryManager<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LdapEntryMapper<T> ldapEntryMapper;
    private final ConnectionFactory connectionFactory;

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory) {
        this.ldapEntryMapper = mapper;
        this.connectionFactory = factory;
    }

    protected LdapEntryMapper<T> getLdapEntryMapper() {
        return this.ldapEntryMapper;
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T find(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        SearchRequest request = SearchRequest.newObjectScopeSearchRequest((String)dn);
        Connection conn = this.getConnectionFactory().getConnection();
        try {
            conn.open();
            SearchOperation search = new SearchOperation(conn);
            Response response = search.execute((Request)request);
            if (((SearchResult)response.getResult()).size() == 0) {
                throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, no entries returned: %s", dn, response));
            }
            if (((SearchResult)response.getResult()).size() > 1) {
                throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, multiple entries returned: %s", dn, response));
            }
            this.getLdapEntryMapper().map(object, ((SearchResult)response.getResult()).getEntry());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> add(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        AddRequest request = new AddRequest(entry.getDn(), entry.getAttributes());
        Connection conn = this.getConnectionFactory().getConnection();
        try {
            conn.open();
            AddOperation add = new AddOperation(conn);
            Response response = add.execute((Request)request);
            return response;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> merge(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        MergeRequest request = new MergeRequest(entry);
        Connection conn = this.getConnectionFactory().getConnection();
        try {
            conn.open();
            MergeOperation merge = new MergeOperation(conn);
            Response response = merge.execute((Request)request);
            return response;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Void> delete(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        DeleteRequest request = new DeleteRequest(dn);
        Connection conn = this.getConnectionFactory().getConnection();
        try {
            conn.open();
            DeleteOperation delete = new DeleteOperation(conn);
            Response response = delete.execute((Request)request);
            return response;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

