/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans;

import java.util.Collection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.ClassDescriptor;
import org.ldaptive.beans.DnValueMutator;
import org.ldaptive.beans.LdapEntryMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLdapEntryMapper<T>
implements LdapEntryMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract ClassDescriptor getClassDescriptor(T var1);

    @Override
    public String mapDn(T object) {
        ClassDescriptor descriptor = this.getClassDescriptor(object);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        return dnMutator.getValue(object);
    }

    public LdapEntry map(T source) {
        LdapEntry dest = new LdapEntry();
        this.map(source, dest);
        return dest;
    }

    @Override
    public void map(T source, LdapEntry dest) {
        this.logger.debug("map {} to {}", source, (Object)dest);
        ClassDescriptor descriptor = this.getClassDescriptor(source);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        if (dnMutator != null) {
            dest.setDn(dnMutator.getValue(source));
        }
        for (AttributeValueMutator mutator : descriptor.getAttributeValueMutators()) {
            Collection<Object> c;
            this.logger.debug("using mutator {}", (Object)mutator);
            if (mutator == null) continue;
            LdapAttribute attr = new LdapAttribute(mutator.getSortBehavior(), mutator.isBinary());
            attr.setName(mutator.getName());
            if (attr.isBinary()) {
                c = mutator.getBinaryValues(source);
                if (c != null) {
                    attr.addBinaryValues(c);
                }
            } else {
                c = mutator.getStringValues(source);
                if (c != null) {
                    attr.addStringValues(c);
                }
            }
            if (attr.size() <= 0) continue;
            dest.addAttribute(new LdapAttribute[]{attr});
        }
    }

    @Override
    public void map(LdapEntry source, T dest) {
        this.logger.debug("map {} to {}", (Object)source, dest);
        ClassDescriptor descriptor = this.getClassDescriptor(dest);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        if (dnMutator != null) {
            dnMutator.setValue(dest, source.getDn());
        }
        for (LdapAttribute attr : source.getAttributes()) {
            if (attr.size() <= 0) continue;
            AttributeValueMutator mutator = descriptor.getAttributeValueMutator(attr.getName());
            this.logger.debug("using mutator {} for attribute {}", (Object)mutator, (Object)attr);
            if (mutator == null) continue;
            if (attr.isBinary()) {
                mutator.setBinaryValues(dest, attr.getBinaryValues());
                continue;
            }
            mutator.setStringValues(dest, attr.getStringValues());
        }
    }
}

