/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring;

import org.ldaptive.beans.AbstractClassDescriptor;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.DnValueMutator;
import org.ldaptive.beans.Entry;
import org.ldaptive.beans.spring.SpelAttributeValueMutator;
import org.ldaptive.beans.spring.SpelDnValueMutator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpringClassDescriptor
extends AbstractClassDescriptor {
    private final EvaluationContext evaluationContext;

    public SpringClassDescriptor(EvaluationContext context) {
        this.evaluationContext = context;
    }

    @Override
    public void initialize(Class<?> type) {
        Entry entryAnnotation = (Entry)AnnotationUtils.findAnnotation(type, Entry.class);
        if (entryAnnotation != null) {
            if (!"".equals(entryAnnotation.dn())) {
                this.setDnValueMutator(this.createDnValueMutator(entryAnnotation.dn()));
            }
            for (Attribute attr : entryAnnotation.attributes()) {
                if ("".equals(attr.property()) && attr.values().length > 0) {
                    this.addAttributeValueMutator(new AbstractClassDescriptor.SimpleAttributeValueMutator(attr.name(), attr.values(), attr.binary(), attr.sortBehavior()));
                    continue;
                }
                this.addAttributeValueMutator(new SpelAttributeValueMutator(attr, this.evaluationContext));
            }
        }
    }

    protected DnValueMutator createDnValueMutator(String dnProperty) {
        try {
            return new SpelDnValueMutator(new SpelExpressionParser().parseExpression(dnProperty), this.evaluationContext);
        }
        catch (SpelParseException e) {
            this.logger.debug("Could not parse dn expression, using SimpleDnValueMutator", (Throwable)e);
            return new AbstractClassDescriptor.SimpleDnValueMutator(dnProperty);
        }
    }
}

