/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.util.ArrayList;
import java.util.Collection;
import org.ldaptive.beans.reflect.ArrayReflectionTranscoder;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.beans.reflect.SingleValueReflectionTranscoder;

public abstract class AbstractCollectionReflectionTranscoder
implements ReflectionTranscoder {
    private final Class<?> type;
    private final SingleValueReflectionTranscoder<?> singleValueTranscoder;
    private final ArrayReflectionTranscoder arrayTranscoder;

    public AbstractCollectionReflectionTranscoder(Class<?> c, SingleValueReflectionTranscoder<?> transcoder) {
        this.type = c;
        this.singleValueTranscoder = transcoder;
        this.arrayTranscoder = null;
    }

    public AbstractCollectionReflectionTranscoder(Class<?> c, ArrayReflectionTranscoder transcoder) {
        this.type = c;
        this.singleValueTranscoder = null;
        this.arrayTranscoder = transcoder;
    }

    @Override
    public Object decodeStringValues(Collection<String> values) {
        Collection<Object> decoded = this.createCollection(Object.class);
        if (this.arrayTranscoder != null) {
            decoded.add(this.arrayTranscoder.decodeStringValues(values));
        } else {
            for (String value : values) {
                ArrayList<String> l = new ArrayList<String>(1);
                l.add(value);
                decoded.add(this.singleValueTranscoder.decodeStringValues(l));
            }
        }
        return decoded;
    }

    @Override
    public Object decodeBinaryValues(Collection<byte[]> values) {
        Collection<Object> decoded = this.createCollection(Object.class);
        if (this.arrayTranscoder != null) {
            decoded.add(this.arrayTranscoder.decodeBinaryValues(values));
        } else {
            for (byte[] value : values) {
                ArrayList<byte[]> l = new ArrayList<byte[]>(1);
                l.add(value);
                decoded.add(this.singleValueTranscoder.decodeBinaryValues(l));
            }
        }
        return decoded;
    }

    @Override
    public Collection<String> encodeStringValues(Object values) {
        Collection<String> encoded = this.createCollection(String.class);
        if (values != null) {
            for (Object o : (Collection)values) {
                if (this.arrayTranscoder != null) {
                    encoded.addAll(this.arrayTranscoder.encodeStringValues(o));
                    continue;
                }
                encoded.addAll(this.singleValueTranscoder.encodeStringValues(o));
            }
        }
        return encoded;
    }

    @Override
    public Collection<byte[]> encodeBinaryValues(Object values) {
        Collection<byte[]> encoded = this.createCollection(byte[].class);
        if (values != null) {
            for (Object o : (Collection)values) {
                if (this.arrayTranscoder != null) {
                    encoded.addAll(this.arrayTranscoder.encodeBinaryValues(o));
                    continue;
                }
                encoded.addAll(this.singleValueTranscoder.encodeBinaryValues(o));
            }
        }
        return encoded;
    }

    protected abstract <T> Collection<T> createCollection(Class<T> var1);

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean supports(Class<?> t) {
        return this.getType().isAssignableFrom(t);
    }

    public String toString() {
        return String.format("[%s@%d::type=%s, singleValueTranscoder=%s, arrayTranscoder=%s]", this.getClass().getName(), this.hashCode(), this.type, this.singleValueTranscoder, this.arrayTranscoder);
    }
}

