/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring;

import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.ad.handler.ObjectGuidHandler;
import org.ldaptive.ad.handler.ObjectSidHandler;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.auth.PooledSearchDnResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.auth.ext.ActiveDirectoryAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordExpirationAuthenticationResponseHandler;
import org.ldaptive.auth.ext.PasswordPolicyAuthenticationResponseHandler;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.handler.SearchEntryHandler;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.SearchValidator;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class NamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("anonymous-search-authenticator", (BeanDefinitionParser)new AnonSearchAuthenticatorBeanDefinitionParser());
        this.registerBeanDefinitionParser("bind-search-authenticator", (BeanDefinitionParser)new BindSearchAuthenticatorBeanDefinitionParser());
        this.registerBeanDefinitionParser("direct-authenticator", (BeanDefinitionParser)new DirectAuthenticatorBeanDefinitionParser());
        this.registerBeanDefinitionParser("ad-authenticator", (BeanDefinitionParser)new ADAuthenticatorBeanDefinitionParser());
        this.registerBeanDefinitionParser("pooled-connection-factory", (BeanDefinitionParser)new PooledConnectionFactoryBeanDefinitionParser());
        this.registerBeanDefinitionParser("connection-factory", (BeanDefinitionParser)new ConnectionFactoryBeanDefinitionParser());
        this.registerBeanDefinitionParser("search-executor", (BeanDefinitionParser)new SearchExecutorBeanDefinitionParser());
    }

    private static class SearchExecutorBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private SearchExecutorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "search-executor";
        }

        protected Class<?> getBeanClass(Element element) {
            return SearchExecutor.class;
        }

        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            builder.addPropertyValue("baseDn", (Object)element.getAttribute("baseDn"));
            if (element.hasAttribute("searchFilter")) {
                BeanDefinitionBuilder filter = BeanDefinitionBuilder.genericBeanDefinition(SearchFilter.class);
                filter.addPropertyValue("filter", (Object)element.getAttribute("searchFilter"));
                builder.addPropertyValue("searchFilter", (Object)filter.getBeanDefinition());
            }
            if (element.hasAttribute("returnAttributes")) {
                builder.addPropertyValue("returnAttributes", (Object)element.getAttribute("returnAttributes"));
            }
            builder.addPropertyValue("searchScope", (Object)element.getAttribute("searchScope"));
            builder.addPropertyValue("timeLimit", (Object)element.getAttribute("timeLimit"));
            builder.addPropertyValue("sizeLimit", (Object)element.getAttribute("sizeLimit"));
            if (element.hasAttribute("binaryAttributes")) {
                builder.addPropertyValue("binaryAttributes", (Object)element.getAttribute("binaryAttributes"));
            }
            builder.addPropertyValue("sortBehavior", (Object)element.getAttribute("sortBehavior"));
        }
    }

    private static abstract class AbstractConnectionFactoryBeanDefinitionParser
    extends AbstractSingleBeanDefinitionParser {
        private AbstractConnectionFactoryBeanDefinitionParser() {
        }

        protected BeanDefinition parseConnectionConfig(Element element) {
            BeanDefinitionBuilder credentialConfig;
            BeanDefinitionBuilder connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
            connectionConfig.addPropertyValue("ldapUrl", (Object)element.getAttribute("ldapUrl"));
            connectionConfig.addPropertyValue("useStartTLS", (Object)element.getAttribute("useStartTLS"));
            connectionConfig.addPropertyValue("useSSL", (Object)element.getAttribute("useSSL"));
            connectionConfig.addPropertyValue("connectTimeout", (Object)element.getAttribute("connectTimeout"));
            if (element.hasAttribute("trustCertificates")) {
                credentialConfig = BeanDefinitionBuilder.genericBeanDefinition(X509CredentialConfig.class);
                credentialConfig.addPropertyValue("trustCertificates", (Object)element.getAttribute("trustCertificates"));
                BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
                sslConfig.addPropertyValue("credentialConfig", (Object)credentialConfig.getBeanDefinition());
                connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            } else if (element.hasAttribute("trustStore")) {
                credentialConfig = BeanDefinitionBuilder.genericBeanDefinition(KeyStoreCredentialConfig.class);
                credentialConfig.addPropertyValue("trustStore", (Object)element.getAttribute("trustStore"));
                credentialConfig.addPropertyValue("trustStorePassword", (Object)element.getAttribute("trustStorePassword"));
                credentialConfig.addPropertyValue("trustStoreType", (Object)element.getAttribute("trustStoreType"));
                BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
                sslConfig.addPropertyValue("credentialConfig", (Object)credentialConfig.getBeanDefinition());
                connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            }
            if (element.hasAttribute("bindDn") && element.hasAttribute("bindCredential")) {
                BeanDefinitionBuilder initializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
                initializer.addPropertyValue("bindDn", (Object)element.getAttribute("bindDn"));
                initializer.addPropertyValue("bindCredential", (Object)element.getAttribute("bindCredential"));
                connectionConfig.addPropertyValue("connectionInitializer", (Object)initializer.getBeanDefinition());
            }
            return connectionConfig.getBeanDefinition();
        }

        protected BeanDefinition parseProvider(Element element) {
            BeanDefinitionBuilder provider = BeanDefinitionBuilder.genericBeanDefinition((String)element.getAttribute("provider"));
            return provider.getBeanDefinition();
        }
    }

    private static abstract class AbstractPooledConnectionFactoryBeanDefinitionParser
    extends AbstractConnectionFactoryBeanDefinitionParser {
        private AbstractPooledConnectionFactoryBeanDefinitionParser() {
        }

        protected BeanDefinition parseConnectionPool(String name, Element element) {
            BeanDefinitionBuilder pool = BeanDefinitionBuilder.genericBeanDefinition(BlockingConnectionPool.class);
            pool.addPropertyValue("name", (Object)name);
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
            factory.addPropertyValue("connectionConfig", (Object)this.parseConnectionConfig(element));
            if (element.hasAttribute("provider")) {
                factory.addPropertyValue("provider", (Object)this.parseProvider(element));
            }
            pool.addPropertyValue("connectionFactory", (Object)factory.getBeanDefinition());
            pool.addPropertyValue("poolConfig", (Object)this.parsePoolConfig(element));
            pool.addPropertyValue("blockWaitTime", (Object)element.getAttribute("blockWaitTime"));
            pool.addPropertyValue("failFastInitialize", (Object)element.getAttribute("failFastInitialize"));
            BeanDefinitionBuilder pruneStrategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
            pruneStrategy.addConstructorArgValue((Object)element.getAttribute("prunePeriod"));
            pruneStrategy.addConstructorArgValue((Object)element.getAttribute("idleTime"));
            pool.addPropertyValue("pruneStrategy", (Object)pruneStrategy.getBeanDefinition());
            pool.addPropertyValue("validator", (Object)new SearchValidator());
            pool.setInitMethodName("initialize");
            return pool.getBeanDefinition();
        }

        protected BeanDefinition parsePoolConfig(Element element) {
            BeanDefinitionBuilder poolConfig = BeanDefinitionBuilder.genericBeanDefinition(PoolConfig.class);
            poolConfig.addPropertyValue("minPoolSize", (Object)element.getAttribute("minPoolSize"));
            poolConfig.addPropertyValue("maxPoolSize", (Object)element.getAttribute("maxPoolSize"));
            poolConfig.addPropertyValue("validateOnCheckOut", (Object)element.getAttribute("validateOnCheckOut"));
            poolConfig.addPropertyValue("validatePeriodically", (Object)element.getAttribute("validatePeriodically"));
            poolConfig.addPropertyValue("validatePeriod", (Object)element.getAttribute("validatePeriod"));
            return poolConfig.getBeanDefinition();
        }
    }

    private static abstract class AbstractAuthenticatorBeanDefinitionParser
    extends AbstractPooledConnectionFactoryBeanDefinitionParser {
        private AbstractAuthenticatorBeanDefinitionParser() {
        }

        protected Class<?> getBeanClass(Element element) {
            return Authenticator.class;
        }

        protected BeanDefinition parseAuthHandler(Element element) {
            BeanDefinitionBuilder authHandler = BeanDefinitionBuilder.genericBeanDefinition(PooledBindAuthenticationHandler.class);
            BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            connectionFactory.addPropertyValue("connectionPool", (Object)this.parseConnectionPool("bind-pool", element));
            authHandler.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
            if (element.hasAttribute("usePasswordPolicy")) {
                BeanDefinitionBuilder control = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePasswordPolicyControl");
                control.addConstructorArgValue((Object)element.getAttribute("usePasswordPolicy"));
                authHandler.addPropertyValue("authenticationControls", (Object)control.getBeanDefinition());
            }
            return authHandler.getBeanDefinition();
        }

        protected static AuthenticationResponseHandler[] parsePasswordPolicyAuthenticationResponseHandler(String value) {
            AuthenticationResponseHandler[] authenticationResponseHandlerArray;
            if (Boolean.valueOf(value).booleanValue()) {
                AuthenticationResponseHandler[] authenticationResponseHandlerArray2 = new AuthenticationResponseHandler[2];
                authenticationResponseHandlerArray2[0] = new PasswordPolicyAuthenticationResponseHandler();
                authenticationResponseHandlerArray = authenticationResponseHandlerArray2;
                authenticationResponseHandlerArray2[1] = new PasswordExpirationAuthenticationResponseHandler();
            } else {
                authenticationResponseHandlerArray = null;
            }
            return authenticationResponseHandlerArray;
        }

        protected static RequestControl[] parsePasswordPolicyControl(String value) {
            RequestControl[] requestControlArray;
            if (Boolean.valueOf(value).booleanValue()) {
                RequestControl[] requestControlArray2 = new RequestControl[1];
                requestControlArray = requestControlArray2;
                requestControlArray2[0] = new PasswordPolicyControl();
            } else {
                requestControlArray = null;
            }
            return requestControlArray;
        }
    }

    private static abstract class AbstractSearchAuthenticatorBeanDefinitionParser
    extends AbstractAuthenticatorBeanDefinitionParser {
        private AbstractSearchAuthenticatorBeanDefinitionParser() {
        }

        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            BeanDefinition pool = this.parseConnectionPool("search-pool", element);
            BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            connectionFactory.addPropertyValue("connectionPool", (Object)pool);
            BeanDefinitionBuilder resolver = BeanDefinitionBuilder.genericBeanDefinition(PooledSearchDnResolver.class);
            resolver.addPropertyValue("baseDn", (Object)element.getAttribute("baseDn"));
            resolver.addPropertyValue("subtreeSearch", (Object)element.getAttribute("subtreeSearch"));
            resolver.addPropertyValue("userFilter", (Object)element.getAttribute("userFilter"));
            resolver.addPropertyValue("allowMultipleDns", (Object)element.getAttribute("allowMultipleDns"));
            resolver.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
            if (element.hasAttribute("usePasswordPolicy")) {
                BeanDefinitionBuilder responseHandler = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePasswordPolicyAuthenticationResponseHandler");
                responseHandler.addConstructorArgValue((Object)element.getAttribute("usePasswordPolicy"));
                builder.addPropertyValue("authenticationResponseHandlers", (Object)responseHandler.getBeanDefinition());
            }
            builder.addConstructorArgValue((Object)resolver.getBeanDefinition());
            builder.addConstructorArgValue((Object)this.parseAuthHandler(element));
        }
    }

    private static class ConnectionFactoryBeanDefinitionParser
    extends AbstractConnectionFactoryBeanDefinitionParser {
        private ConnectionFactoryBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "connection-factory";
        }

        protected Class<?> getBeanClass(Element element) {
            return DefaultConnectionFactory.class;
        }

        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            builder.addPropertyValue("connectionConfig", (Object)this.parseConnectionConfig(element));
            if (element.hasAttribute("provider")) {
                builder.addPropertyValue("provider", (Object)this.parseProvider(element));
            }
        }
    }

    private static class PooledConnectionFactoryBeanDefinitionParser
    extends AbstractPooledConnectionFactoryBeanDefinitionParser {
        private PooledConnectionFactoryBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "pooled-connection-factory";
        }

        protected Class<?> getBeanClass(Element element) {
            return PooledConnectionFactory.class;
        }

        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            builder.addPropertyValue("connectionPool", (Object)this.parseConnectionPool("connection-pool", element));
        }
    }

    private static class ADAuthenticatorBeanDefinitionParser
    extends AbstractSearchAuthenticatorBeanDefinitionParser {
        private ADAuthenticatorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "ad-authenticator";
        }

        @Override
        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            super.doParse(element, context, builder);
            builder.addPropertyValue("authenticationResponseHandlers", (Object)new ActiveDirectoryAuthenticationResponseHandler());
            BeanDefinitionBuilder resolver = BeanDefinitionBuilder.genericBeanDefinition(SearchEntryResolver.class);
            resolver.addPropertyValue("searchEntryHandlers", (Object)new SearchEntryHandler[]{new ObjectGuidHandler(), new ObjectSidHandler()});
            builder.addPropertyValue("entryResolver", (Object)resolver.getBeanDefinition());
        }
    }

    private static class DirectAuthenticatorBeanDefinitionParser
    extends AbstractAuthenticatorBeanDefinitionParser {
        private DirectAuthenticatorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "direct-authenticator";
        }

        protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
            BeanDefinitionBuilder dnResolver = BeanDefinitionBuilder.genericBeanDefinition(FormatDnResolver.class);
            dnResolver.addConstructorArgValue((Object)element.getAttribute("format"));
            builder.addConstructorArgValue((Object)dnResolver.getBeanDefinition());
            builder.addConstructorArgValue((Object)this.parseAuthHandler(element));
            if (element.hasAttribute("usePasswordPolicy")) {
                BeanDefinitionBuilder responseHandler = BeanDefinitionBuilder.rootBeanDefinition(AbstractAuthenticatorBeanDefinitionParser.class, (String)"parsePasswordPolicyAuthenticationResponseHandler");
                responseHandler.addConstructorArgValue((Object)element.getAttribute("usePasswordPolicy"));
                builder.addPropertyValue("authenticationResponseHandlers", (Object)responseHandler.getBeanDefinition());
            }
        }
    }

    private static class BindSearchAuthenticatorBeanDefinitionParser
    extends AbstractSearchAuthenticatorBeanDefinitionParser {
        private BindSearchAuthenticatorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "bind-search-authenticator";
        }
    }

    private static class AnonSearchAuthenticatorBeanDefinitionParser
    extends AbstractSearchAuthenticatorBeanDefinitionParser {
        private AnonSearchAuthenticatorBeanDefinitionParser() {
        }

        protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
            String idAttrValue = element.getAttribute("id");
            return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "anonymous-search-authenticator";
        }
    }
}

