/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import org.ldaptive.beans.AbstractClassDescriptor;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.Entry;
import org.ldaptive.beans.reflect.FieldClassDescriptor;
import org.ldaptive.beans.reflect.MethodClassDescriptor;

public class DefaultClassDescriptor
extends AbstractClassDescriptor {
    @Override
    public void initialize(Class<?> type) {
        Entry entryAnnotation = type.getAnnotation(Entry.class);
        if (entryAnnotation != null) {
            MethodClassDescriptor methodDescriptor = new MethodClassDescriptor();
            methodDescriptor.initialize(type);
            if (methodDescriptor.getDnValueMutator() != null) {
                this.setDnValueMutator(methodDescriptor.getDnValueMutator());
            }
            this.addAttributeValueMutator(methodDescriptor.getAttributeValueMutators());
            FieldClassDescriptor fieldDescriptor = new FieldClassDescriptor();
            fieldDescriptor.initialize(type);
            if (this.getDnValueMutator() == null && fieldDescriptor.getDnValueMutator() != null) {
                this.setDnValueMutator(fieldDescriptor.getDnValueMutator());
            }
            fieldDescriptor.getAttributeValueMutators().stream().filter(mutator -> this.getAttributeValueMutator(mutator.getName()) == null).forEach(this::addAttributeValueMutator);
            for (Attribute attr : entryAnnotation.attributes()) {
                if (!"".equals(attr.property()) || attr.values().length <= 0) continue;
                this.addAttributeValueMutator(new AbstractClassDescriptor.SimpleAttributeValueMutator(attr.name(), attr.values(), attr.binary(), attr.sortBehavior()));
            }
            if (this.getDnValueMutator() == null) {
                this.setDnValueMutator(new AbstractClassDescriptor.SimpleDnValueMutator(entryAnnotation.dn()));
            }
        }
    }
}

