/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.persistence;

import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AddResponse;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DeleteResponse;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.beans.LdapEntryMapper;
import org.ldaptive.beans.persistence.LdapEntryManager;
import org.ldaptive.ext.MergeOperation;
import org.ldaptive.ext.MergeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapEntryManager<T>
implements LdapEntryManager<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LdapEntryMapper<T> ldapEntryMapper;
    private final ConnectionFactory connectionFactory;
    private final String[] returnAttributes;

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory) {
        this(mapper, factory, null);
    }

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory, String[] attrs) {
        this.ldapEntryMapper = mapper;
        this.connectionFactory = factory;
        this.returnAttributes = attrs;
    }

    public LdapEntryMapper<T> getLdapEntryMapper() {
        return this.ldapEntryMapper;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    @Override
    public T find(T object) throws LdapException {
        SearchRequest request;
        SearchOperation search;
        SearchResponse response;
        String dn = this.getLdapEntryMapper().mapDn(object);
        Object[] attrs = ReturnAttributes.ALL.value();
        if (this.returnAttributes != null) {
            attrs = (String[])LdapUtils.concatArrays((Object[])attrs, (Object[][])new String[][]{this.returnAttributes});
        }
        if ((response = (search = new SearchOperation(this.connectionFactory)).execute(request = SearchRequest.objectScopeSearchRequest((String)dn, (String[])attrs))).entrySize() == 0) {
            throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, no entries returned: %s", dn, response));
        }
        if (response.entrySize() > 1) {
            throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, multiple entries returned: %s", dn, response));
        }
        this.getLdapEntryMapper().map(response.getEntry(), object);
        return object;
    }

    @Override
    public AddResponse add(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        return AddOperation.execute((ConnectionFactory)this.connectionFactory, (AddRequest)new AddRequest(entry.getDn(), entry.getAttributes()));
    }

    @Override
    public Result merge(T object) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        MergeOperation merge = new MergeOperation(this.connectionFactory);
        return merge.execute(new MergeRequest(entry));
    }

    @Override
    public DeleteResponse delete(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        return DeleteOperation.execute((ConnectionFactory)this.connectionFactory, (DeleteRequest)new DeleteRequest(dn));
    }
}

