/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.beans.spring.parser.AbstractBeanDefinitionParser;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractConnectionConfigBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected BeanDefinitionBuilder parseConnectionConfig(BeanDefinitionBuilder builder, Element element, boolean includeConnectionInitializer) {
        BeanDefinitionBuilder sslConfig;
        BeanDefinitionBuilder connectionConfig = builder;
        if (connectionConfig == null) {
            connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
        }
        this.setIfPresent(element, "ldapUrl", connectionConfig);
        BeanDefinitionBuilder connectTimeout = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        connectTimeout.addConstructorArgValue((Object)element.getAttribute("connectTimeout"));
        connectionConfig.addPropertyValue("connectTimeout", (Object)connectTimeout.getBeanDefinition());
        BeanDefinitionBuilder responseTimeout = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        responseTimeout.addConstructorArgValue((Object)element.getAttribute("responseTimeout"));
        connectionConfig.addPropertyValue("responseTimeout", (Object)responseTimeout.getBeanDefinition());
        BeanDefinitionBuilder reconnectTimeout = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
        reconnectTimeout.addConstructorArgValue((Object)element.getAttribute("reconnectTimeout"));
        connectionConfig.addPropertyValue("reconnectTimeout", (Object)reconnectTimeout.getBeanDefinition());
        connectionConfig.addPropertyValue("useStartTLS", (Object)element.getAttribute("useStartTLS"));
        connectionConfig.addPropertyValue("autoReconnect", (Object)element.getAttribute("autoReconnect"));
        connectionConfig.addPropertyValue("autoReplay", (Object)element.getAttribute("autoReplay"));
        if (element.hasAttribute("autoReconnectCondition")) {
            BeanDefinitionBuilder autoReconnectCondition = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseClassName");
            autoReconnectCondition.addConstructorArgValue((Object)element.getAttribute("autoReconnectCondition"));
            connectionConfig.addPropertyValue("autoReconnectCondition", (Object)autoReconnectCondition.getBeanDefinition());
        }
        if (element.hasAttribute("connectionStrategy")) {
            BeanDefinitionBuilder connectionStrategy = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseClassName");
            connectionStrategy.addConstructorArgValue((Object)element.getAttribute("connectionStrategy"));
            connectionConfig.addPropertyValue("connectionStrategy", (Object)connectionStrategy.getBeanDefinition());
        }
        if (element.hasAttribute("trustCertificates") || element.hasAttribute("authenticationCertificate")) {
            sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            sslConfig.addPropertyValue("credentialConfig", (Object)this.parseX509CredentialConfig(null, element).getBeanDefinition());
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
        } else if (element.hasAttribute("trustStore") || element.hasAttribute("keyStore")) {
            sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            sslConfig.addPropertyValue("credentialConfig", (Object)this.parseKeyStoreCredentialConfig(null, element).getBeanDefinition());
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
        }
        if (includeConnectionInitializer && element.hasAttribute("bindDn")) {
            connectionConfig.addPropertyValue("connectionInitializers", (Object)this.parseConnectionInitializer(null, element).getBeanDefinition());
        }
        return connectionConfig;
    }

    protected BeanDefinitionBuilder parseConnectionInitializer(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder initializer = builder;
        if (initializer == null) {
            initializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
        }
        initializer.addPropertyValue("bindDn", (Object)element.getAttribute("bindDn"));
        this.setIfPresent(element, "bindCredential", initializer);
        return initializer;
    }

    protected BeanDefinitionBuilder parseX509CredentialConfig(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder credentialConfig = builder;
        if (credentialConfig == null) {
            credentialConfig = BeanDefinitionBuilder.genericBeanDefinition(X509CredentialConfig.class);
        }
        this.setIfPresent(element, "trustCertificates", credentialConfig);
        this.setIfPresent(element, "authenticationCertificate", credentialConfig);
        this.setIfPresent(element, "authenticationKey", credentialConfig);
        return credentialConfig;
    }

    protected BeanDefinitionBuilder parseKeyStoreCredentialConfig(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder credentialConfig = builder;
        if (credentialConfig == null) {
            credentialConfig = BeanDefinitionBuilder.genericBeanDefinition(KeyStoreCredentialConfig.class);
        }
        this.setIfPresent(element, "trustStore", credentialConfig);
        this.setIfPresent(element, "trustStorePassword", credentialConfig);
        this.setIfPresent(element, "trustStoreType", credentialConfig);
        this.setIfPresent(element, "trustStoreAliases", credentialConfig);
        this.setIfPresent(element, "keyStore", credentialConfig);
        this.setIfPresent(element, "keyStorePassword", credentialConfig);
        this.setIfPresent(element, "keyStoreType", credentialConfig);
        this.setIfPresent(element, "keyStoreAliases", credentialConfig);
        return credentialConfig;
    }
}

