/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.SearchEntryResolver;
import org.ldaptive.beans.spring.parser.AbstractAuthenticatorBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractSearchAuthenticatorBeanDefinitionParser
extends AbstractAuthenticatorBeanDefinitionParser {
    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder dnResolver;
        BeanDefinitionBuilder connectionFactory;
        Object name = "search-pool";
        if (element.hasAttribute("id")) {
            name = element.getAttribute("id") + "-search-pool";
        }
        if (element.getAttribute("disablePooling") != null && Boolean.valueOf(element.getAttribute("disablePooling")).booleanValue()) {
            connectionFactory = this.parseDefaultConnectionFactory(null, element, true);
            dnResolver = this.parseDnResolver(BeanDefinitionBuilder.genericBeanDefinition(SearchDnResolver.class), element, connectionFactory);
        } else {
            connectionFactory = this.parsePooledConnectionFactory(null, (String)name, element, true);
            dnResolver = this.parseDnResolver(null, element, connectionFactory);
        }
        BeanDefinitionBuilder authHandler = this.parseAuthHandler(element);
        BeanDefinitionBuilder authResponseHandler = this.parseAuthResponseHandler(builder, authHandler, element);
        if (authResponseHandler != null) {
            builder.addPropertyValue("responseHandlers", (Object)authResponseHandler.getBeanDefinition());
        }
        builder.addConstructorArgValue((Object)dnResolver.getBeanDefinition());
        builder.addConstructorArgValue((Object)authHandler.getBeanDefinition());
        BeanDefinitionBuilder entryResolver = this.parseEntryResolver(element, connectionFactory);
        builder.addPropertyValue("entryResolver", (Object)entryResolver.getBeanDefinition());
        this.setIfPresent(element, "returnAttributes", builder);
        builder.addPropertyValue("resolveEntryOnFailure", (Object)element.getAttribute("resolveEntryOnFailure"));
    }

    protected BeanDefinitionBuilder parseDnResolver(BeanDefinitionBuilder builder, Element element, BeanDefinitionBuilder connectionFactory) {
        BeanDefinitionBuilder dnResolver = builder;
        if (dnResolver == null) {
            dnResolver = BeanDefinitionBuilder.genericBeanDefinition(SearchDnResolver.class);
        }
        dnResolver.addPropertyValue("baseDn", (Object)element.getAttribute("baseDn"));
        dnResolver.addPropertyValue("subtreeSearch", (Object)element.getAttribute("subtreeSearch"));
        dnResolver.addPropertyValue("userFilter", (Object)element.getAttribute("userFilter"));
        dnResolver.addPropertyValue("allowMultipleDns", (Object)element.getAttribute("allowMultipleDns"));
        dnResolver.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        return dnResolver;
    }

    protected BeanDefinitionBuilder parseEntryResolver(Element element, BeanDefinitionBuilder connectionFactory) {
        BeanDefinitionBuilder entryResolver = BeanDefinitionBuilder.genericBeanDefinition(SearchEntryResolver.class);
        entryResolver.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
        return entryResolver;
    }
}

