/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import java.util.HashMap;
import java.util.List;
import org.ldaptive.auth.AggregateAuthenticationHandler;
import org.ldaptive.auth.AggregateAuthenticationResponseHandler;
import org.ldaptive.auth.AggregateDnResolver;
import org.ldaptive.auth.AggregateEntryResolver;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.beans.spring.parser.ADAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.AbstractAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.AnonSearchAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.BindSearchAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.DirectAuthenticatorBeanDefinitionParser;
import org.ldaptive.beans.spring.parser.SaslBindSearchAuthenticatorBeanDefinitionParser;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AggregateAuthenticatorBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String idAttrValue = element.getAttribute("id");
        return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "aggregate-authenticator";
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AggregateAuthenticatorFactoryBean.class);
        ManagedList authenticators = new ManagedList();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            AbstractAuthenticatorBeanDefinitionParser parser = null;
            if (child instanceof Element) {
                switch (child.getLocalName()) {
                    case "anonymous-search-authenticator": {
                        parser = new AnonSearchAuthenticatorBeanDefinitionParser();
                        break;
                    }
                    case "bind-search-authenticator": {
                        parser = new BindSearchAuthenticatorBeanDefinitionParser();
                        break;
                    }
                    case "sasl-bind-search-authenticator": {
                        parser = new SaslBindSearchAuthenticatorBeanDefinitionParser();
                        break;
                    }
                    case "direct-authenticator": {
                        parser = new DirectAuthenticatorBeanDefinitionParser();
                        break;
                    }
                    case "ad-authenticator": {
                        parser = new ADAuthenticatorBeanDefinitionParser();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown authenticator type: " + child.getLocalName());
                    }
                }
            }
            if (parser == null) continue;
            authenticators.add((Object)parser.parse((Element)child, context));
        }
        factory.addPropertyValue("authenticators", (Object)authenticators);
        factory.addPropertyValue("allowMultipleDns", (Object)element.getAttribute("allowMultipleDns"));
        if (element.hasAttribute("returnAttributes")) {
            factory.addPropertyValue("returnAttributes", (Object)element.getAttribute("returnAttributes"));
        }
        factory.addPropertyValue("resolveEntryOnFailure", (Object)element.getAttribute("resolveEntryOnFailure"));
        return factory.getBeanDefinition();
    }

    protected static class AggregateAuthenticatorFactoryBean
    implements FactoryBean<Authenticator> {
        private List<Authenticator> authenticators;
        private boolean allowMultipleDns;
        private String[] returnAttributes;
        private boolean resolveEntryOnFailure;

        protected AggregateAuthenticatorFactoryBean() {
        }

        public void setAuthenticators(List<Authenticator> auths) {
            this.authenticators = auths;
        }

        public void setAllowMultipleDns(boolean b) {
            this.allowMultipleDns = b;
        }

        public void setReturnAttributes(String ... attrs) {
            this.returnAttributes = attrs;
        }

        public void setResolveEntryOnFailure(boolean b) {
            this.resolveEntryOnFailure = b;
        }

        public Authenticator getObject() throws Exception {
            Authenticator aggregateAuth = new Authenticator();
            HashMap<String, DnResolver> dnResolvers = new HashMap<String, DnResolver>();
            HashMap<String, AuthenticationHandler> authHandlers = new HashMap<String, AuthenticationHandler>();
            HashMap<String, EntryResolver> entryResolvers = new HashMap<String, EntryResolver>();
            HashMap<String, AuthenticationResponseHandler[]> responseHandlers = new HashMap<String, AuthenticationResponseHandler[]>();
            int count = 0;
            for (Authenticator auth : this.authenticators) {
                String id = String.format("%s-%s", auth.hashCode(), String.valueOf(count++));
                dnResolvers.put(id, auth.getDnResolver());
                authHandlers.put(id, auth.getAuthenticationHandler());
                if (auth.getEntryResolver() != null) {
                    entryResolvers.put(id, auth.getEntryResolver());
                }
                if (auth.getResponseHandlers() == null) continue;
                responseHandlers.put(id, auth.getResponseHandlers());
            }
            AggregateDnResolver dnResolver = new AggregateDnResolver();
            dnResolver.setAllowMultipleDns(this.allowMultipleDns);
            dnResolver.setDnResolvers(dnResolvers);
            aggregateAuth.setDnResolver((DnResolver)dnResolver);
            AggregateAuthenticationHandler authHandler = new AggregateAuthenticationHandler();
            authHandler.setAuthenticationHandlers(authHandlers);
            aggregateAuth.setAuthenticationHandler((AuthenticationHandler)authHandler);
            if (!entryResolvers.isEmpty()) {
                AggregateEntryResolver entryResolver = new AggregateEntryResolver();
                entryResolver.setEntryResolvers(entryResolvers);
                aggregateAuth.setEntryResolver((EntryResolver)entryResolver);
            }
            if (!responseHandlers.isEmpty()) {
                AggregateAuthenticationResponseHandler responseHandler = new AggregateAuthenticationResponseHandler();
                responseHandler.setAuthenticationResponseHandlers(responseHandlers);
                aggregateAuth.setResponseHandlers(new AuthenticationResponseHandler[]{responseHandler});
            }
            aggregateAuth.setReturnAttributes(this.returnAttributes);
            aggregateAuth.setResolveEntryOnFailure(this.resolveEntryOnFailure);
            return aggregateAuth;
        }

        public Class<Authenticator> getObjectType() {
            return Authenticator.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

