/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.util.HashMap;
import java.util.Map;
import org.ldaptive.transcode.ValueTranscoder;

public final class TranscoderFactory {
    private static final Map<String, ValueTranscoder<?>> TRANSCODERS = new HashMap();

    private TranscoderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueTranscoder<?> getInstance(String type) {
        ValueTranscoder<?> transcoder;
        if (type == null || "".equals(type)) {
            return null;
        }
        Map<String, ValueTranscoder<?>> map = TRANSCODERS;
        synchronized (map) {
            if (!TRANSCODERS.containsKey(type)) {
                transcoder = TranscoderFactory.createValueTranscoder(type);
                TRANSCODERS.put(type, transcoder);
            } else {
                transcoder = TRANSCODERS.get(type);
            }
        }
        return transcoder;
    }

    private static ValueTranscoder<?> createValueTranscoder(String type) {
        try {
            return (ValueTranscoder)Class.forName(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate transcoder", e);
        }
    }
}

