/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ldaptive.beans.reflect.AbstractCollectionReflectionTranscoder;
import org.ldaptive.beans.reflect.ArrayReflectionTranscoder;
import org.ldaptive.beans.reflect.ListReflectionTranscoder;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.beans.reflect.ReflectionUtils;
import org.ldaptive.beans.reflect.SetReflectionTranscoder;
import org.ldaptive.beans.reflect.SingleValueReflectionTranscoder;
import org.ldaptive.transcode.BigIntegerValueTranscoder;
import org.ldaptive.transcode.BooleanValueTranscoder;
import org.ldaptive.transcode.ByteArrayValueTranscoder;
import org.ldaptive.transcode.CertificateValueTranscoder;
import org.ldaptive.transcode.CharArrayValueTranscoder;
import org.ldaptive.transcode.DoubleValueTranscoder;
import org.ldaptive.transcode.FloatValueTranscoder;
import org.ldaptive.transcode.GeneralizedTimeValueTranscoder;
import org.ldaptive.transcode.IntegerValueTranscoder;
import org.ldaptive.transcode.LongValueTranscoder;
import org.ldaptive.transcode.ObjectValueTranscoder;
import org.ldaptive.transcode.ShortValueTranscoder;
import org.ldaptive.transcode.StringValueTranscoder;
import org.ldaptive.transcode.UUIDValueTranscoder;
import org.ldaptive.transcode.ValueTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReflectionTranscoder
implements ReflectionTranscoder {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SingleValueReflectionTranscoder<?> customTranscoder;
    private final ReflectionTranscoder valueTranscoder;
    private final Set<SingleValueReflectionTranscoder<?>> singleValueTranscoders;

    public DefaultReflectionTranscoder(Type type) {
        this(type, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultReflectionTranscoder(Type type, ValueTranscoder<?> transcoder) {
        this.customTranscoder = transcoder != null ? SingleValueReflectionTranscoder.newInstance(transcoder) : null;
        this.singleValueTranscoders = this.getDefaultSingleValueTranscoders();
        if (type instanceof Class) {
            Class c = (Class)type;
            this.valueTranscoder = c.isArray() ? (byte[].class == c || char[].class == c ? this.getSingleValueReflectionTranscoder(c) : new ArrayReflectionTranscoder(this.getSingleValueReflectionTranscoder(c.getComponentType()))) : (Collection.class.isAssignableFrom(c) ? this.getCollectionEncoder(c, (Type)((Object)Object.class)) : this.getSingleValueReflectionTranscoder(c));
            return;
        } else {
            if (!(type instanceof ParameterizedType)) throw new IllegalArgumentException("Unsupported type: " + type);
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            Object[] typeArgs = pt.getActualTypeArguments();
            if (typeArgs.length != 1) {
                throw new IllegalArgumentException("Unsupported type arguments: " + Arrays.toString(typeArgs));
            }
            Class<?> rawClass = ReflectionUtils.classFromType(rawType);
            if (typeArgs[0] instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)typeArgs[0];
                if (!Collection.class.isAssignableFrom(rawClass)) throw new IllegalArgumentException("Unsupported type: " + rawClass);
                this.valueTranscoder = this.getCollectionEncoder(rawClass, gat);
                return;
            } else {
                if (!(typeArgs[0] instanceof Class)) throw new IllegalArgumentException("Unsupported type: " + rawClass);
                if (!Collection.class.isAssignableFrom(rawClass)) throw new IllegalArgumentException("Unsupported type: " + rawClass);
                this.valueTranscoder = this.getCollectionEncoder(rawClass, (Type)typeArgs[0]);
            }
        }
    }

    protected Set<SingleValueReflectionTranscoder<?>> getDefaultSingleValueTranscoders() {
        HashSet transcoders = new HashSet();
        transcoders.add(new SingleValueReflectionTranscoder(new ObjectValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new BooleanValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new BooleanValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new DoubleValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new DoubleValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new FloatValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new FloatValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new IntegerValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new IntegerValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new LongValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new LongValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new ShortValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new ShortValueTranscoder(true)));
        transcoders.add(new SingleValueReflectionTranscoder(new StringValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new ByteArrayValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new CharArrayValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new CertificateValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new GeneralizedTimeValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new UUIDValueTranscoder()));
        transcoders.add(new SingleValueReflectionTranscoder(new BigIntegerValueTranscoder()));
        return transcoders;
    }

    protected SingleValueReflectionTranscoder getSingleValueReflectionTranscoder(Class<?> type) {
        if (this.customTranscoder != null) {
            return this.customTranscoder;
        }
        for (SingleValueReflectionTranscoder<?> transcoder : this.singleValueTranscoders) {
            boolean supports = transcoder.supports(type);
            if (!supports) continue;
            return transcoder;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    protected ReflectionTranscoder getCollectionEncoder(Class<?> type, Type genericType) {
        AbstractCollectionReflectionTranscoder encoder;
        Class<Object> genericClass;
        boolean isGenericArray = false;
        if (genericType instanceof GenericArrayType) {
            Class<?> c = ReflectionUtils.classFromType(((GenericArrayType)genericType).getGenericComponentType());
            if (Byte.TYPE == c) {
                genericClass = byte[].class;
            } else if (Character.TYPE == c) {
                genericClass = char[].class;
            } else {
                genericClass = c;
                isGenericArray = true;
            }
        } else {
            genericClass = ReflectionUtils.classFromType(genericType);
        }
        if (type == Collection.class || List.class.isAssignableFrom(type)) {
            encoder = isGenericArray ? new ListReflectionTranscoder(type, new ArrayReflectionTranscoder(this.getSingleValueReflectionTranscoder(genericClass))) : new ListReflectionTranscoder(type, this.getSingleValueReflectionTranscoder(genericClass));
        } else if (Set.class.isAssignableFrom(type)) {
            encoder = isGenericArray ? new SetReflectionTranscoder(type, new ArrayReflectionTranscoder(this.getSingleValueReflectionTranscoder(genericClass))) : new SetReflectionTranscoder(type, this.getSingleValueReflectionTranscoder(genericClass));
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type + " with generic type: " + genericType);
        }
        return encoder;
    }

    @Override
    public Object decodeStringValues(Collection<String> values) {
        return this.valueTranscoder.decodeStringValues(values);
    }

    @Override
    public Object decodeBinaryValues(Collection<byte[]> values) {
        return this.valueTranscoder.decodeBinaryValues(values);
    }

    @Override
    public Collection<String> encodeStringValues(Object values) {
        return this.valueTranscoder.encodeStringValues(values);
    }

    @Override
    public Collection<byte[]> encodeBinaryValues(Object values) {
        return this.valueTranscoder.encodeBinaryValues(values);
    }

    @Override
    public Class<?> getType() {
        return this.valueTranscoder.getType();
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.valueTranscoder.supports(type);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::customTranscoder=" + this.customTranscoder + ", valueTranscoder=" + this.valueTranscoder + "]";
    }
}

