/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.ldaptive.beans.reflect.AbstractAttributeValueMutator;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.beans.reflect.ReflectionUtils;

public class FieldAttributeValueMutator
extends AbstractAttributeValueMutator {
    private final Field f;
    private final boolean isFinal;

    public FieldAttributeValueMutator(ReflectionTranscoder transcoder, Field field) {
        super(null, false, transcoder);
        this.f = field;
        this.f.setAccessible(true);
        this.isFinal = Modifier.isFinal(this.f.getModifiers());
    }

    public FieldAttributeValueMutator(String name, boolean binary, ReflectionTranscoder transcoder, Field field) {
        super(name, binary, transcoder);
        this.f = field;
        this.f.setAccessible(true);
        this.isFinal = Modifier.isFinal(this.f.getModifiers());
    }

    @Override
    public Collection<String> getStringValues(Object object) {
        return this.getReflectionTranscoder().encodeStringValues(ReflectionUtils.getField(this.f, object));
    }

    @Override
    public Collection<byte[]> getBinaryValues(Object object) {
        return this.getReflectionTranscoder().encodeBinaryValues(ReflectionUtils.getField(this.f, object));
    }

    @Override
    public void setStringValues(Object object, Collection<String> values) {
        if (!this.isFinal) {
            ReflectionUtils.setField(this.f, object, this.getReflectionTranscoder().decodeStringValues(values));
        }
    }

    @Override
    public void setBinaryValues(Object object, Collection<byte[]> values) {
        if (!this.isFinal) {
            ReflectionUtils.setField(this.f, object, this.getReflectionTranscoder().decodeBinaryValues(values));
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::name=" + this.getName() + ", binary=" + this.isBinary() + ", reflectionTranscoder=" + this.getReflectionTranscoder() + ", field=" + this.f + "]";
    }
}

