/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans;

import java.util.Collection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.ClassDescriptor;
import org.ldaptive.beans.DnValueMutator;
import org.ldaptive.beans.LdapEntryMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLdapEntryMapper<T>
implements LdapEntryMapper<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract ClassDescriptor getClassDescriptor(T var1);

    @Override
    public String mapDn(T object) {
        ClassDescriptor descriptor = this.getClassDescriptor(object);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        return dnMutator.getValue(object);
    }

    public LdapEntry map(T source) {
        LdapEntry dest = new LdapEntry();
        this.map(source, dest);
        return dest;
    }

    @Override
    public void map(T source, LdapEntry dest) {
        ClassDescriptor descriptor = this.getClassDescriptor(source);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        this.logger.trace("using dn mutator {} on {}", (Object)dnMutator, source);
        if (dnMutator != null) {
            dest.setDn(this.mapDn(source, dnMutator));
        }
        for (AttributeValueMutator mutator : descriptor.getAttributeValueMutators()) {
            LdapAttribute attr;
            this.logger.trace("using attribute value mutator {} on {}", (Object)mutator, source);
            if (mutator == null || (attr = this.mapValue(source, mutator)).size() <= 0) continue;
            dest.addAttributes(new LdapAttribute[]{attr});
        }
        this.logger.debug("Mapped {} to {}", source, (Object)dest);
    }

    protected String mapDn(T source, DnValueMutator mutator) {
        return mutator.getValue(source);
    }

    protected LdapAttribute mapValue(T source, AttributeValueMutator mutator) {
        LdapAttribute attr = new LdapAttribute();
        attr.setBinary(mutator.isBinary());
        attr.setName(mutator.getName());
        if (attr.isBinary()) {
            Collection<byte[]> c = mutator.getBinaryValues(source);
            if (c != null) {
                attr.addBinaryValues(c);
            }
        } else {
            Collection<String> c = mutator.getStringValues(source);
            if (c != null) {
                attr.addStringValues(c);
            }
        }
        return attr;
    }

    @Override
    public void map(LdapEntry source, T dest) {
        ClassDescriptor descriptor = this.getClassDescriptor(dest);
        DnValueMutator dnMutator = descriptor.getDnValueMutator();
        this.logger.trace("using dn mutator {} for entry {}", (Object)dnMutator, (Object)source);
        if (dnMutator != null) {
            this.mapDn(source.getDn(), dest, dnMutator);
        }
        for (LdapAttribute attr : source.getAttributes()) {
            if (attr.size() <= 0) continue;
            AttributeValueMutator mutator = descriptor.getAttributeValueMutator(attr.getName());
            this.logger.trace("using mutator {} for attribute {}", (Object)mutator, (Object)attr);
            if (mutator == null) continue;
            this.mapValue(attr, dest, mutator);
        }
        this.logger.debug("Mapped {} to {}", (Object)source, dest);
    }

    protected void mapDn(String dn, T dest, DnValueMutator mutator) {
        mutator.setValue(dest, dn);
    }

    protected void mapValue(LdapAttribute attr, T dest, AttributeValueMutator mutator) {
        if (attr.isBinary()) {
            mutator.setBinaryValues(dest, attr.getBinaryValues());
        } else {
            mutator.setStringValues(dest, attr.getStringValues());
        }
    }
}

