/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.generate;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ldaptive.LdapUtils;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.Entry;
import org.ldaptive.beans.generate.props.BeanGeneratorPropertySource;
import org.ldaptive.schema.AbstractNamedSchemaElement;
import org.ldaptive.schema.AbstractSchemaElement;
import org.ldaptive.schema.AttributeType;
import org.ldaptive.schema.AttributeUsage;
import org.ldaptive.schema.ObjectClass;
import org.ldaptive.schema.Schema;
import org.ldaptive.schema.Syntax;

public class BeanGenerator {
    private final JCodeModel codeModel = new JCodeModel();
    private Schema schema;
    private String packageName;
    private String[] objectClasses;
    private boolean useOptionalAttributes = true;
    private boolean useOperationalAttributes;
    private boolean includeSuperiorClasses;
    private Map<String, Class<?>> typeMappings = BeanGenerator.getDefaultTypeMappings();
    private Map<String, String> nameMappings = new HashMap<String, String>();
    private String[] excludedNames = new String[0];

    public BeanGenerator() {
    }

    public BeanGenerator(Schema s, String name, String[] oc) {
        this.schema = s;
        this.packageName = name;
        this.objectClasses = oc;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema s) {
        this.schema = s;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public String[] getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(String ... oc) {
        this.objectClasses = oc;
    }

    public boolean isUseOptionalAttributes() {
        return this.useOptionalAttributes;
    }

    public void setUseOptionalAttributes(boolean b) {
        this.useOptionalAttributes = b;
    }

    public boolean isUseOperationalAttributes() {
        return this.useOperationalAttributes;
    }

    public void setUseOperationalAttributes(boolean b) {
        this.useOperationalAttributes = b;
    }

    public boolean isIncludeSuperiorClasses() {
        return this.includeSuperiorClasses;
    }

    public void setIncludeSuperiorClasses(boolean b) {
        this.includeSuperiorClasses = b;
    }

    public Map<String, Class<?>> getTypeMappings() {
        return this.typeMappings;
    }

    public void setTypeMappings(Map<String, Class<?>> m) {
        this.typeMappings = m;
    }

    public Map<String, String> getNameMappings() {
        return this.nameMappings;
    }

    public void setNameMappings(Map<String, String> m) {
        Objects.requireNonNull(m, "Name mappings cannot be null");
        this.nameMappings = m;
    }

    public String[] getExcludedNames() {
        return this.excludedNames;
    }

    public void setExcludedNames(String ... names) {
        Objects.requireNonNull(names, "Excluded names cannot be null");
        this.excludedNames = names;
    }

    protected static Map<String, Class<?>> getDefaultTypeMappings() {
        HashMap m = new HashMap();
        m.put("1.3.6.1.4.1.1466.115.121.1.7", Boolean.class);
        m.put("1.3.6.1.4.1.1466.115.121.1.5", byte[].class);
        m.put("1.3.6.1.4.1.1466.115.121.1.8", Certificate.class);
        m.put("1.3.6.1.4.1.1466.115.121.1.24", ZonedDateTime.class);
        m.put("1.3.6.1.4.1.1466.115.121.1.36", Integer.class);
        m.put("1.3.6.1.1.16.1", UUID.class);
        return m;
    }

    protected Class<?> getSyntaxType(AttributeType type, Syntax syntax) {
        Class t = null;
        for (Map.Entry<String, Class<?>> entry : this.typeMappings.entrySet()) {
            if (!entry.getKey().equals(type.getSyntaxOID(false))) continue;
            t = entry.getValue();
        }
        if (t == null) {
            t = Syntax.containsBooleanExtension((AbstractSchemaElement)syntax, (String)"X-NOT-HUMAN-READABLE") ? byte[].class : String.class;
        }
        return t;
    }

    public void generate() {
        for (String objectClass : this.objectClasses) {
            JDefinedClass definedClass = this.createClass(this.packageName, objectClass);
            JDocComment jDocComment = definedClass.javadoc();
            jDocComment.add((Object)String.format("Ldaptive generated bean for objectClass '%s'", objectClass));
            ObjectClass oc = this.schema.getObjectClass(objectClass);
            Set<String> attributeNames = this.getAttributeNames(oc);
            if (this.useOperationalAttributes) {
                attributeNames.addAll(this.schema.getAttributeTypes().stream().filter(type -> AttributeUsage.DIRECTORY_OPERATION.equals((Object)type.getUsage())).map(AbstractNamedSchemaElement::getName).collect(Collectors.toList()));
            }
            TreeMap<String, AttributeType> mutators = new TreeMap<String, AttributeType>();
            for (String name : attributeNames) {
                AttributeType type2 = this.schema.getAttributeType(name);
                if (this.isNameExcluded(type2)) continue;
                if (this.nameMappings.containsKey(type2.getName())) {
                    mutators.put(this.nameMappings.get(type2.getName()), type2);
                    continue;
                }
                mutators.put(this.formatAttributeName(type2.getName()), type2);
            }
            JAnnotationUse entryAnnotation = definedClass.annotate(this.codeModel.ref(Entry.class));
            entryAnnotation.param("dn", "dn");
            JAnnotationArrayMember attrArray = entryAnnotation.paramArray("attributes");
            this.createMutators(definedClass, "dn", String.class, false);
            for (Map.Entry mutator : mutators.entrySet()) {
                Class<?> syntaxType = this.getSyntaxType((AttributeType)mutator.getValue(), this.schema.getSyntax(((AttributeType)mutator.getValue()).getSyntaxOID(false)));
                this.createMutators(definedClass, (String)mutator.getKey(), syntaxType, !((AttributeType)mutator.getValue()).isSingleValued());
                JAnnotationUse attrAnnotation = attrArray.annotate(Attribute.class);
                attrAnnotation.param("name", ((AttributeType)mutator.getValue()).getName());
                if (!((String)mutator.getKey()).equals(((AttributeType)mutator.getValue()).getName())) {
                    attrAnnotation.param("property", (String)mutator.getKey());
                }
                if (!byte[].class.equals(syntaxType)) continue;
                attrAnnotation.param("binary", true);
            }
            this.createHashCode(definedClass);
            this.createEquals(definedClass);
            this.createToString(definedClass);
        }
    }

    private Set<String> getAttributeNames(ObjectClass objectClass) {
        return this.getAttributeNames(objectClass, new HashSet<ObjectClass>());
    }

    private Set<String> getAttributeNames(ObjectClass objectClass, Set<ObjectClass> processed) {
        HashSet<String> attributeNames = new HashSet<String>();
        if (objectClass != null) {
            if (objectClass.getRequiredAttributes() != null) {
                attributeNames.addAll(Arrays.asList(objectClass.getRequiredAttributes()));
            }
            if (this.useOptionalAttributes && objectClass.getOptionalAttributes() != null) {
                attributeNames.addAll(Arrays.asList(objectClass.getOptionalAttributes()));
            }
            processed.add(objectClass);
            if (this.includeSuperiorClasses && objectClass.getSuperiorClasses() != null) {
                for (String oc : objectClass.getSuperiorClasses()) {
                    ObjectClass superiorOc = this.schema.getObjectClass(oc);
                    if (processed.contains(superiorOc)) continue;
                    attributeNames.addAll(this.getAttributeNames(superiorOc, processed));
                }
            }
        }
        return attributeNames;
    }

    private String formatAttributeName(String name) {
        String formatted = name.contains("-") ? name.replace("-", "") : name;
        return formatted;
    }

    private boolean isNameExcluded(AttributeType type) {
        if (this.excludedNames != null && this.excludedNames.length > 0) {
            for (String excluded : this.excludedNames) {
                if (!type.getOID().equals(excluded) && !type.hasName(excluded)) continue;
                return true;
            }
        }
        return false;
    }

    protected JDefinedClass createClass(String classPackage, String className) {
        String fqClassName = !Character.isUpperCase(className.charAt(0)) ? String.format("%s.%s", classPackage, Character.toUpperCase(className.charAt(0)) + className.substring(1)) : String.format("%s.%s", classPackage, className);
        try {
            return this.codeModel._class(fqClassName);
        }
        catch (JClassAlreadyExistsException e) {
            throw new IllegalArgumentException("Class already exists: " + fqClassName, e);
        }
    }

    protected void createMutators(JDefinedClass clazz, String name, Class<?> syntaxType, boolean multivalue) {
        String upperName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        if (multivalue) {
            JClass detailClass = this.codeModel.ref(syntaxType);
            JClass collectionClass = this.codeModel.ref(Collection.class);
            JClass genericClass = collectionClass.narrow(detailClass);
            JFieldVar field = clazz.field(4, (JType)genericClass, name);
            JMethod getterMethod = clazz.method(1, (JType)genericClass, "get" + upperName);
            getterMethod.body()._return((JExpression)field);
            JMethod setterMethod = clazz.method(1, Void.TYPE, "set" + upperName);
            setterMethod.param((JType)genericClass, "c");
            setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(name), (JExpression)JExpr.ref((String)"c"));
        } else {
            JFieldVar field = clazz.field(4, syntaxType, name);
            JMethod getterMethod = clazz.method(1, syntaxType, "get" + upperName);
            getterMethod.body()._return((JExpression)field);
            JMethod setterMethod = clazz.method(1, Void.TYPE, "set" + upperName);
            setterMethod.param(syntaxType, "s");
            setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(name), (JExpression)JExpr.ref((String)"s"));
        }
    }

    private void createHashCode(JDefinedClass clazz) {
        JClass ldapUtilsClass = this.codeModel.ref(LdapUtils.class);
        JInvocation computeHashCode = ldapUtilsClass.staticInvoke("computeHashCode");
        JMethod hashCode = clazz.method(1, Integer.TYPE, "hashCode");
        hashCode.annotate(Override.class);
        computeHashCode.arg(JExpr.lit((int)7919));
        for (Map.Entry entry : clazz.fields().entrySet()) {
            computeHashCode.arg((JExpression)JExpr._this().ref((JVar)entry.getValue()));
        }
        hashCode.body()._return((JExpression)computeHashCode);
    }

    private void createEquals(JDefinedClass clazz) {
        JMethod equals = clazz.method(1, Boolean.TYPE, "equals");
        equals.annotate(Override.class);
        JVar o = equals.param(Object.class, "o");
        JConditional ifSame = equals.body()._if(o.eq(JExpr._this()));
        ifSame._then()._return(JExpr.TRUE);
        JConditional ifInstance = equals.body()._if(o._instanceof((JType)clazz));
        JVar v = ifInstance._then().decl((JType)clazz, "v", (JExpression)JExpr.cast((JType)clazz, (JExpression)o));
        JInvocation propertyComparison = null;
        for (Map.Entry entry : clazz.fields().entrySet()) {
            JClass ldapUtilsClass = this.codeModel.ref(LdapUtils.class);
            JInvocation areEqual = ldapUtilsClass.staticInvoke("areEqual");
            areEqual.arg((JExpression)entry.getValue());
            areEqual.arg((JExpression)v.ref((JVar)entry.getValue()));
            if (propertyComparison == null) {
                propertyComparison = areEqual;
                continue;
            }
            propertyComparison = propertyComparison.cand((JExpression)areEqual);
        }
        ifInstance._then()._return(propertyComparison);
        equals.body()._return(JExpr.FALSE);
    }

    private void createToString(JDefinedClass clazz) {
        JClass stringClass = this.codeModel.ref(String.class);
        JInvocation format = stringClass.staticInvoke("format");
        JMethod toString = clazz.method(1, String.class, "toString");
        toString.annotate(Override.class);
        StringBuilder sb = new StringBuilder("[%s@%d::");
        for (Map.Entry entry : clazz.fields().entrySet()) {
            sb.append((String)entry.getKey()).append("=%s, ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]");
        format.arg(sb.toString());
        format.arg((JExpression)JExpr._this().invoke("getClass").invoke("getName"));
        format.arg((JExpression)JExpr._this().invoke("hashCode"));
        for (Map.Entry entry : clazz.fields().entrySet()) {
            format.arg((JExpression)JExpr._this().ref((JVar)entry.getValue()));
        }
        toString.body()._return((JExpression)format);
    }

    public void write() throws IOException {
        this.write(".");
    }

    public void write(String path) throws IOException {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        this.codeModel.build(f);
    }

    public static void main(String[] args) throws Exception {
        String propsPath = args[0];
        String targetPath = args[1];
        BeanGenerator generator = new BeanGenerator();
        BeanGeneratorPropertySource source = new BeanGeneratorPropertySource(generator, propsPath);
        source.initialize();
        generator.generate();
        generator.write(targetPath);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final BeanGenerator object = new BeanGenerator();

        protected Builder() {
        }

        public Builder schema(Schema schema) {
            this.object.setSchema(schema);
            return this;
        }

        public Builder packageName(String name) {
            this.object.setPackageName(name);
            return this;
        }

        public Builder objectClasses(String ... classes) {
            this.object.setObjectClasses(classes);
            return this;
        }

        public Builder useOptionalAttributes(boolean b) {
            this.object.setUseOptionalAttributes(b);
            return this;
        }

        public Builder useOperationalAttributes(boolean b) {
            this.object.setUseOperationalAttributes(b);
            return this;
        }

        public Builder includeSuperiorClasses(boolean b) {
            this.object.setIncludeSuperiorClasses(b);
            return this;
        }

        public Builder typeMappings(Map<String, Class<?>> mappings) {
            this.object.setTypeMappings(mappings);
            return this;
        }

        public Builder nameMappings(Map<String, String> mappings) {
            this.object.setNameMappings(mappings);
            return this;
        }

        public Builder excludedNames(String ... classes) {
            this.object.setExcludedNames(classes);
            return this;
        }

        public BeanGenerator build() {
            return this.object;
        }
    }
}

