/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.persistence;

import org.ldaptive.AbstractFreezable;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AddResponse;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DeleteResponse;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.beans.LdapEntryMapper;
import org.ldaptive.beans.persistence.LdapEntryManager;
import org.ldaptive.ext.MergeOperation;
import org.ldaptive.ext.MergeRequest;
import org.ldaptive.handler.ResultPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapEntryManager<T>
extends AbstractFreezable
implements LdapEntryManager<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LdapEntryMapper<T> ldapEntryMapper;
    private final ConnectionFactory connectionFactory;
    private final String[] returnAttributes;
    private SearchOperation searchOperation;
    private AddOperation addOperation;
    private MergeOperation mergeOperation;
    private DeleteOperation deleteOperation;

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory) {
        this(mapper, factory, null);
    }

    public DefaultLdapEntryManager(LdapEntryMapper<T> mapper, ConnectionFactory factory, String[] attrs) {
        this.ldapEntryMapper = mapper;
        this.connectionFactory = factory;
        this.returnAttributes = attrs;
    }

    public LdapEntryMapper<T> getLdapEntryMapper() {
        return this.ldapEntryMapper;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public String[] getReturnAttributes() {
        return (String[])LdapUtils.copyArray((Object[])this.returnAttributes);
    }

    public SearchOperation getSearchOperation() {
        return this.isFrozen() ? SearchOperation.copy((SearchOperation)this.searchOperation) : this.searchOperation;
    }

    public void setSearchOperation(SearchOperation operation) {
        this.assertMutable();
        this.searchOperation = operation;
    }

    public AddOperation getAddOperation() {
        return this.isFrozen() ? AddOperation.copy((AddOperation)this.addOperation) : this.addOperation;
    }

    public void setAddOperation(AddOperation operation) {
        this.assertMutable();
        this.addOperation = operation;
    }

    public MergeOperation getMergeOperation() {
        return this.isFrozen() ? MergeOperation.copy((MergeOperation)this.mergeOperation) : this.mergeOperation;
    }

    public void setMergeOperation(MergeOperation operation) {
        this.assertMutable();
        this.mergeOperation = operation;
    }

    public DeleteOperation getDeleteOperation() {
        return this.isFrozen() ? DeleteOperation.copy((DeleteOperation)this.deleteOperation) : this.deleteOperation;
    }

    public void setDeleteOperation(DeleteOperation operation) {
        this.assertMutable();
        this.deleteOperation = operation;
    }

    @Override
    public T find(T object) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        Object[] attrs = ReturnAttributes.ALL.value();
        if (this.returnAttributes != null) {
            attrs = (String[])LdapUtils.concatArrays((Object[])attrs, (Object[][])new String[][]{this.returnAttributes});
        }
        SearchRequest request = SearchRequest.objectScopeSearchRequest((String)dn, (String[])attrs);
        SearchOperation search = this.searchOperation != null ? SearchOperation.copy((SearchOperation)this.searchOperation) : new SearchOperation();
        search.setConnectionFactory(this.connectionFactory);
        SearchResponse response = search.execute(request);
        if (!response.isSuccess() || response.entrySize() == 0) {
            throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, no entries returned: %s", dn, response));
        }
        if (response.entrySize() > 1) {
            throw new IllegalArgumentException(String.format("Unable to find ldap entry %s, multiple entries returned: %s", dn, response));
        }
        this.getLdapEntryMapper().map(response.getEntry(), object);
        return object;
    }

    @Override
    public AddResponse add(T object) throws LdapException {
        return this.add(object, null);
    }

    public AddResponse add(T object, ResultPredicate predicate) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        AddOperation add = this.addOperation != null ? AddOperation.copy((AddOperation)this.addOperation) : new AddOperation();
        add.setConnectionFactory(this.connectionFactory);
        if (predicate != null) {
            add.setThrowCondition(predicate);
        }
        return add.execute(new AddRequest(entry.getDn(), entry.getAttributes()));
    }

    @Override
    public Result merge(T object) throws LdapException {
        return this.merge(object, null);
    }

    public Result merge(T object, ResultPredicate predicate) throws LdapException {
        LdapEntry entry = new LdapEntry();
        this.getLdapEntryMapper().map(object, entry);
        MergeOperation merge = this.mergeOperation != null ? MergeOperation.copy((MergeOperation)this.mergeOperation) : new MergeOperation();
        merge.setConnectionFactory(this.connectionFactory);
        if (predicate != null) {
            merge.setThrowCondition(predicate);
        }
        return merge.execute(new MergeRequest(entry));
    }

    @Override
    public DeleteResponse delete(T object) throws LdapException {
        return this.delete(object, null);
    }

    public DeleteResponse delete(T object, ResultPredicate predicate) throws LdapException {
        String dn = this.getLdapEntryMapper().mapDn(object);
        DeleteOperation delete = this.deleteOperation != null ? DeleteOperation.copy((DeleteOperation)this.deleteOperation) : new DeleteOperation();
        delete.setConnectionFactory(this.connectionFactory);
        if (predicate != null) {
            delete.setThrowCondition(predicate);
        }
        return delete.execute(new DeleteRequest(dn));
    }
}

