/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.Method;
import java.util.Collection;
import org.ldaptive.beans.reflect.AbstractAttributeValueMutator;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.beans.reflect.ReflectionUtils;

public class MethodAttributeValueMutator
extends AbstractAttributeValueMutator {
    private final Method getterMethod;
    private final Method setterMethod;

    public MethodAttributeValueMutator(ReflectionTranscoder transcoder, Method getter, Method setter) {
        super(null, false, transcoder);
        this.getterMethod = getter;
        if (this.getterMethod != null) {
            this.getterMethod.setAccessible(true);
        }
        this.setterMethod = setter;
        if (this.setterMethod != null) {
            this.setterMethod.setAccessible(true);
        }
    }

    public MethodAttributeValueMutator(String name, boolean binary, ReflectionTranscoder transcoder, Method getter, Method setter) {
        super(name, binary, transcoder);
        this.getterMethod = getter;
        if (this.getterMethod != null) {
            this.getterMethod.setAccessible(true);
        }
        this.setterMethod = setter;
        if (this.setterMethod != null) {
            this.setterMethod.setAccessible(true);
        }
    }

    @Override
    public Collection<String> getStringValues(Object object) {
        if (this.getterMethod == null) {
            return null;
        }
        return this.getReflectionTranscoder().encodeStringValues(ReflectionUtils.invokeGetterMethod(this.getterMethod, object));
    }

    @Override
    public Collection<byte[]> getBinaryValues(Object object) {
        if (this.getterMethod == null) {
            return null;
        }
        return this.getReflectionTranscoder().encodeBinaryValues(ReflectionUtils.invokeGetterMethod(this.getterMethod, object));
    }

    @Override
    public void setStringValues(Object object, Collection<String> values) {
        if (this.setterMethod != null) {
            ReflectionUtils.invokeSetterMethod(this.setterMethod, object, this.getReflectionTranscoder().decodeStringValues(values));
        }
    }

    @Override
    public void setBinaryValues(Object object, Collection<byte[]> values) {
        if (this.setterMethod != null) {
            ReflectionUtils.invokeSetterMethod(this.setterMethod, object, this.getReflectionTranscoder().decodeBinaryValues(values));
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::name=" + this.getName() + ", binary=" + this.isBinary() + ", reflectionTranscoder=" + String.valueOf(this.getReflectionTranscoder()) + ", getterMethod=" + String.valueOf(this.getterMethod) + ", setterMethod=" + String.valueOf(this.setterMethod) + "]";
    }
}

