/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.util.ArrayList;
import java.util.Collection;
import org.ldaptive.beans.reflect.ReflectionTranscoder;
import org.ldaptive.transcode.ValueTranscoder;

public class SingleValueReflectionTranscoder<T>
implements ReflectionTranscoder {
    private final ValueTranscoder<T> valueTranscoder;

    public SingleValueReflectionTranscoder(ValueTranscoder<T> transcoder) {
        this.valueTranscoder = transcoder;
    }

    public static <T> SingleValueReflectionTranscoder<T> newInstance(ValueTranscoder<T> transcoder) {
        return new SingleValueReflectionTranscoder<T>(transcoder);
    }

    @Override
    public Object decodeStringValues(Collection<String> values) {
        if (values != null && values.size() > 1) {
            throw new IllegalArgumentException("Multiple values not supported");
        }
        if (values != null && !values.isEmpty()) {
            return this.valueTranscoder.decodeStringValue(values.iterator().next());
        }
        return null;
    }

    @Override
    public Object decodeBinaryValues(Collection<byte[]> values) {
        if (values != null && values.size() > 1) {
            throw new IllegalArgumentException("Multiple values not supported");
        }
        if (values != null && !values.isEmpty()) {
            return this.valueTranscoder.decodeBinaryValue(values.iterator().next());
        }
        return null;
    }

    @Override
    public Collection<String> encodeStringValues(Object value) {
        String s;
        ArrayList<String> l = new ArrayList<String>(1);
        if (value != null && (s = this.valueTranscoder.encodeStringValue(value)) != null) {
            l.add(s);
        }
        return l;
    }

    @Override
    public Collection<byte[]> encodeBinaryValues(Object value) {
        byte[] b;
        ArrayList<byte[]> l = new ArrayList<byte[]>(1);
        if (value != null && (b = this.valueTranscoder.encodeBinaryValue(value)) != null) {
            l.add(b);
        }
        return l;
    }

    @Override
    public Class<?> getType() {
        return this.valueTranscoder.getType();
    }

    @Override
    public boolean supports(Class<?> type) {
        return this.getType().equals(type);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::valueTranscoder=" + String.valueOf(this.valueTranscoder) + "]";
    }
}

