/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.json.simple.JSONValue;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.io.SearchResultWriter;

public class JsonWriter
implements SearchResultWriter {
    private final Writer jsonWriter;

    public JsonWriter(Writer writer) {
        this.jsonWriter = writer;
    }

    public void write(SearchResult result) throws IOException {
        ArrayList json = new ArrayList();
        for (LdapEntry e : result.getEntries()) {
            LinkedHashMap<String, Object> jsonEntry = new LinkedHashMap<String, Object>();
            String dn = e.getDn();
            if (dn != null) {
                jsonEntry.put("dn", e.getDn());
            }
            for (LdapAttribute a : e.getAttributes()) {
                String name = a.getName();
                ArrayList l = new ArrayList();
                l.addAll(a.getStringValues());
                jsonEntry.put(name, l);
            }
            json.add(jsonEntry);
        }
        JSONValue.writeJSONString(json, (Writer)this.jsonWriter);
        this.jsonWriter.flush();
    }
}

