/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.SortBehavior;
import org.ldaptive.io.SearchResultReader;

public class JsonReader
implements SearchResultReader {
    private final Reader jsonReader;
    private final SortBehavior sortBehavior;

    public JsonReader(Reader reader) {
        this(reader, SortBehavior.getDefaultSortBehavior());
    }

    public JsonReader(Reader reader, SortBehavior sb) {
        this.jsonReader = reader;
        if (sb == null) {
            throw new IllegalArgumentException("Sort behavior cannot be null");
        }
        this.sortBehavior = sb;
    }

    public SearchResult read() throws IOException {
        SearchResult result = new SearchResult(this.sortBehavior);
        try {
            JSONParser parser = new JSONParser();
            JSONArray jsonArray = (JSONArray)parser.parse(this.jsonReader);
            for (Object o : jsonArray) {
                LdapEntry entry = new LdapEntry(this.sortBehavior);
                JSONObject jsonObject = (JSONObject)o;
                for (Object k : jsonObject.keySet()) {
                    String attrName = (String)k;
                    if ("dn".equalsIgnoreCase(attrName)) {
                        entry.setDn((String)jsonObject.get(k));
                        continue;
                    }
                    LdapAttribute attr = new LdapAttribute(this.sortBehavior);
                    attr.setName(attrName);
                    attr.addStringValues((Collection)((List)jsonObject.get(k)));
                    entry.addAttribute(new LdapAttribute[]{attr});
                }
                result.addEntry(new LdapEntry[]{entry});
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        return result;
    }
}

