/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.SortBehavior;
import org.ldaptive.io.SearchResultReader;

public class JsonReader
implements SearchResultReader {
    private final Reader jsonReader;
    private final Gson gson;

    public JsonReader(Reader reader) {
        this(reader, SortBehavior.getDefaultSortBehavior());
    }

    public JsonReader(Reader reader, SortBehavior sb) {
        this.jsonReader = reader;
        if (sb == null) {
            throw new IllegalArgumentException("Sort behavior cannot be null");
        }
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SearchResult.class, (Object)new SearchResultDeserializer(sb));
        this.gson = builder.disableHtmlEscaping().create();
    }

    public SearchResult read() throws IOException {
        try {
            return (SearchResult)this.gson.fromJson(this.jsonReader, SearchResult.class);
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    private static class SearchResultDeserializer
    implements JsonDeserializer<SearchResult> {
        private final SortBehavior sortBehavior;

        SearchResultDeserializer(SortBehavior sb) {
            this.sortBehavior = sb;
        }

        public SearchResult deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            SearchResult result = new SearchResult(this.sortBehavior);
            JsonArray jsonResult = json.getAsJsonArray();
            for (JsonElement jsonEntry : jsonResult) {
                LdapEntry entry = new LdapEntry(this.sortBehavior);
                for (Map.Entry jsonAttr : jsonEntry.getAsJsonObject().entrySet()) {
                    if ("dn".equals(jsonAttr.getKey())) {
                        entry.setDn(((JsonElement)jsonAttr.getValue()).getAsString());
                        continue;
                    }
                    LdapAttribute attr = new LdapAttribute(this.sortBehavior);
                    attr.setName((String)jsonAttr.getKey());
                    ((JsonElement)jsonAttr.getValue()).getAsJsonArray().forEach(i -> attr.addStringValue(new String[]{i.getAsString()}));
                    entry.addAttribute(new LdapAttribute[]{attr});
                }
                result.addEntry(new LdapEntry[]{entry});
            }
            return result;
        }
    }
}

