/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.io.SearchResultWriter;

public class JsonWriter
implements SearchResultWriter {
    private final Writer jsonWriter;
    private final Gson gson;

    public JsonWriter(Writer writer) {
        this.jsonWriter = writer;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(SearchResult.class, (Object)new SearchResultSerializer());
        this.gson = builder.disableHtmlEscaping().create();
    }

    public void write(SearchResult result) throws IOException {
        this.gson.toJson((Object)result, (Appendable)this.jsonWriter);
        this.jsonWriter.flush();
    }

    private static class SearchResultSerializer
    implements JsonSerializer<SearchResult> {
        private SearchResultSerializer() {
        }

        public JsonElement serialize(SearchResult result, Type type, JsonSerializationContext context) {
            JsonArray json = new JsonArray();
            for (LdapEntry entry : result.getEntries()) {
                JsonObject jsonEntry = new JsonObject();
                jsonEntry.add("dn", (JsonElement)(entry.getDn() != null ? new JsonPrimitive(entry.getDn()) : null));
                for (LdapAttribute attr : entry.getAttributes()) {
                    JsonArray jsonAttrValues = new JsonArray();
                    attr.getStringValues().forEach(arg_0 -> ((JsonArray)jsonAttrValues).add(arg_0));
                    jsonEntry.add(attr.getName(), (JsonElement)jsonAttrValues);
                }
                json.add((JsonElement)jsonEntry);
            }
            return json;
        }
    }
}

