/*
  $Id: NetscapeControlHandler.java 2616 2013-02-12 18:06:47Z dfisher $

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2616 $
  Updated: $Date: 2013-02-12 13:06:47 -0500 (Tue, 12 Feb 2013) $
*/
package org.ldaptive.provider.netscape;

import org.ldaptive.control.ControlFactory;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.provider.ControlHandler;

/**
 * Netscape control handler.
 *
 * @author  Middleware Services
 * @version  $Revision: 2616 $ $Date: 2013-02-12 13:06:47 -0500 (Tue, 12 Feb 2013) $
 */
public class NetscapeControlHandler
  implements ControlHandler<netscape.ldap.LDAPControl>
{


  /** {@inheritDoc} */
  @Override
  public String getOID(final netscape.ldap.LDAPControl control)
  {
    return control.getID();
  }


  /** {@inheritDoc} */
  @Override
  public netscape.ldap.LDAPControl handleRequest(
    final RequestControl requestControl)
  {
    return
      new netscape.ldap.LDAPControl(
        requestControl.getOID(),
        requestControl.getCriticality(),
        requestControl.encode());
  }


  /** {@inheritDoc} */
  @Override
  public ResponseControl handleResponse(
    final netscape.ldap.LDAPControl responseControl)
  {
    return
      ControlFactory.createResponseControl(
        responseControl.getID(),
        responseControl.isCritical(),
        responseControl.getValue());
  }
}
