/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.opendj;

import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.opendj.OpenDJConnectionFactory;
import org.ldaptive.provider.opendj.OpenDJProviderConfig;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.CredentialConfig;
import org.ldaptive.ssl.DefaultHostnameVerifier;
import org.ldaptive.ssl.DefaultSSLContextInitializer;
import org.ldaptive.ssl.HostnameVerifierConfig;
import org.ldaptive.ssl.HostnameVerifyingTrustManager;

public class OpenDJProvider
implements Provider<OpenDJProviderConfig> {
    private OpenDJProviderConfig config = new OpenDJProviderConfig();

    public ProviderConnectionFactory<OpenDJProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        LDAPOptions options = this.config.getOptions();
        if (options == null) {
            options = this.getDefaultLDAPOptions(cc);
        }
        return new OpenDJConnectionFactory(cc.getLdapUrl(), this.config, options);
    }

    protected SSLContext getHostnameVerifierSSLContext(ConnectionConfig cc) {
        DefaultSSLContextInitializer contextInit;
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        if (cc.getSslConfig() != null && !cc.getSslConfig().isEmpty()) {
            CredentialConfig credConfig = cc.getSslConfig().getCredentialConfig();
            TrustManager[] managers = cc.getSslConfig().getTrustManagers();
            CertificateHostnameVerifier verifier = cc.getSslConfig().getHostnameVerifier();
            if (credConfig != null) {
                try {
                    contextInit = credConfig.createSSLContextInitializer();
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                contextInit = managers != null ? new DefaultSSLContextInitializer(false) : new DefaultSSLContextInitializer(true);
            }
            if (managers != null) {
                contextInit.setTrustManagers(managers);
            }
            if (verifier != null) {
                contextInit.setHostnameVerifierConfig(new HostnameVerifierConfig(verifier, ldapUrl.getEntriesAsString()));
            } else {
                contextInit.setHostnameVerifierConfig(new HostnameVerifierConfig((CertificateHostnameVerifier)new DefaultHostnameVerifier(), ldapUrl.getEntriesAsString()));
            }
        } else {
            contextInit = new DefaultSSLContextInitializer(true);
            contextInit.setTrustManagers(new TrustManager[]{new HostnameVerifyingTrustManager((CertificateHostnameVerifier)new DefaultHostnameVerifier(), ldapUrl.getEntriesAsString())});
        }
        try {
            return contextInit.initSSLContext("TLS");
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected LDAPOptions getDefaultLDAPOptions(ConnectionConfig cc) {
        LDAPOptions options = new LDAPOptions();
        if (cc.getUseStartTLS() || cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://")) {
            SSLContext sslContext = this.getHostnameVerifierSSLContext(cc);
            options.setSSLContext(sslContext);
        }
        if (cc.getUseStartTLS()) {
            options.setUseStartTLS(true);
        } else if (cc.getUseSSL() || cc.getLdapUrl().toLowerCase().contains("ldaps://")) {
            options.setUseStartTLS(false);
        }
        if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledCipherSuites() != null) {
            options.addEnabledCipherSuite(cc.getSslConfig().getEnabledCipherSuites());
        }
        if (cc.getSslConfig() != null && cc.getSslConfig().getEnabledProtocols() != null) {
            options.addEnabledProtocol(cc.getSslConfig().getEnabledProtocols());
        }
        options.setTimeout(cc.getResponseTimeout(), TimeUnit.MILLISECONDS);
        return options;
    }

    public OpenDJProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(OpenDJProviderConfig pc) {
        this.config = pc;
    }

    public OpenDJProvider newInstance() {
        return new OpenDJProvider();
    }
}

