/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.opendj;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ReferralException;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.ExtendedResponseFactory;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.intermediate.IntermediateResponseFactory;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderUtils;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.opendj.OpenDJProviderConfig;
import org.ldaptive.provider.opendj.OpenDJUtils;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SaslConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDJConnection
implements ProviderConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Connection connection;
    private final OpenDJProviderConfig config;
    private final AggregateUnsolicitedNotificationListener notificationListener = new AggregateUnsolicitedNotificationListener();

    public OpenDJConnection(Connection c, OpenDJProviderConfig pc) {
        this.connection = c;
        this.config = pc;
        this.connection.addConnectionEventListener((ConnectionEventListener)this.notificationListener);
    }

    public Connection getLdapConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(RequestControl[] controls) throws LdapException {
        if (this.connection != null) {
            UnbindRequest ur = Requests.newUnbindRequest();
            if (controls != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(controls)) {
                    ur.addControl(c);
                }
            }
            try {
                this.connection.close(ur, "Close requested by client");
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Response<Void> bind(BindRequest request) throws LdapException {
        Response<Void> response = request.getSaslConfig() != null ? this.saslBind(request) : (request.getDn() == null && request.getCredential() == null ? this.anonymousBind(request) : this.simpleBind(request));
        return response;
    }

    protected Response<Void> anonymousBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            SimpleBindRequest sbr = Requests.newSimpleBindRequest();
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    sbr.addControl(c);
                }
            }
            BindResult result = this.connection.bind((org.forgerock.opendj.ldap.requests.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (Result)result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    protected Response<Void> simpleBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            SimpleBindRequest sbr = Requests.newSimpleBindRequest((String)request.getDn(), (char[])request.getCredential().getChars());
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    sbr.addControl(c);
                }
            }
            BindResult result = this.connection.bind((org.forgerock.opendj.ldap.requests.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (Result)result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    protected Response<Void> saslBind(BindRequest request) throws LdapException {
        ExternalSASLBindRequest sbr;
        Response<Object> response = null;
        SaslConfig sc = request.getSaslConfig();
        switch (sc.getMechanism()) {
            case EXTERNAL: {
                sbr = Requests.newExternalSASLBindRequest();
                sbr.setAuthorizationID(sc.getAuthorizationId());
                break;
            }
            case DIGEST_MD5: {
                String digestMd5Realm;
                sbr = Requests.newDigestMD5SASLBindRequest((String)(request.getDn() != null ? request.getDn() : ""), request.getCredential() != null ? request.getCredential().getBytes() : null);
                String string = digestMd5Realm = sc instanceof DigestMd5Config ? ((DigestMd5Config)sc).getRealm() : null;
                if (digestMd5Realm == null && request.getDn().contains("@")) {
                    digestMd5Realm = request.getDn().substring(request.getDn().indexOf("@") + 1);
                }
                if (digestMd5Realm == null) break;
                ((DigestMD5SASLBindRequest)sbr).setRealm(digestMd5Realm);
                break;
            }
            case CRAM_MD5: {
                throw new UnsupportedOperationException("CRAM-MD5 not supported");
            }
            case GSSAPI: {
                throw new UnsupportedOperationException("GSSAPI not supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL authentication mechanism: " + sc.getMechanism());
            }
        }
        if (request.getControls() != null) {
            for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                sbr.addControl(c);
            }
        }
        try {
            BindResult result = this.connection.bind((org.forgerock.opendj.ldap.requests.BindRequest)sbr);
            response = this.createResponse((Request)request, null, (Result)result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    protected static String getQualityOfProtection(QualityOfProtection qop) {
        String name;
        switch (qop) {
            case AUTH: {
                name = "auth";
                break;
            }
            case AUTH_INT: {
                name = "auth-int";
                break;
            }
            case AUTH_CONF: {
                name = "auth-conf";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL quality of protection: " + qop);
            }
        }
        return name;
    }

    public Response<Void> add(AddRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            OpenDJUtils util = new OpenDJUtils();
            org.forgerock.opendj.ldap.requests.AddRequest ar = Requests.newAddRequest((Entry)util.fromLdapEntry(new LdapEntry(request.getDn(), request.getLdapAttributes())));
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    ar.addControl(c);
                }
            }
            Result result = this.connection.add(ar);
            response = this.createResponse((Request)request, null, result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public Response<Boolean> compare(CompareRequest request) throws LdapException {
        Object response = null;
        try {
            OpenDJUtils util = new OpenDJUtils();
            org.forgerock.opendj.ldap.requests.CompareRequest cr = request.getAttribute().isBinary() ? Requests.newCompareRequest((String)request.getDn(), (String)request.getAttribute().getName(), (Object)util.fromBinaryValues(request.getAttribute().getBinaryValues())[0]) : Requests.newCompareRequest((String)request.getDn(), (String)request.getAttribute().getName(), (Object)util.fromStringValues(request.getAttribute().getStringValues())[0]);
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    cr.addControl(c);
                }
            }
            CompareResult result = this.connection.compare(cr);
            response = this.createResponse((Request)request, result.matched(), (Result)result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public Response<Void> delete(DeleteRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            org.forgerock.opendj.ldap.requests.DeleteRequest dr = Requests.newDeleteRequest((String)request.getDn());
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    dr.addControl(c);
                }
            }
            Result result = this.connection.delete(dr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public Response<Void> modify(ModifyRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            OpenDJUtils util = new OpenDJUtils();
            org.forgerock.opendj.ldap.requests.ModifyRequest mr = Requests.newModifyRequest((String)request.getDn());
            for (Modification modification : util.fromAttributeModification(request.getAttributeModifications())) {
                mr.addModification(modification);
            }
            if (request.getControls() != null) {
                for (Modification modification : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    mr.addControl((Control)modification);
                }
            }
            Result result = this.connection.modify(mr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            ModifyDNRequest mdr = Requests.newModifyDNRequest((String)request.getDn(), (String)request.getNewDn());
            mdr.setDeleteOldRDN(request.getDeleteOldRDn());
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(request.getControls())) {
                    mdr.addControl(c);
                }
            }
            Result result = this.connection.modifyDN(mdr);
            response = this.createResponse((Request)request, null, result);
        }
        catch (ReferralException e) {
            response = this.createResponse((Request)request, null, e.getResult());
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public SearchIterator search(SearchRequest request) throws LdapException {
        OpenDJSearchIterator i = new OpenDJSearchIterator(request);
        i.initialize();
        return i;
    }

    public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
        OpenDJAsyncSearchListener l = new OpenDJAsyncSearchListener(request, listener);
        l.initialize();
    }

    public void abandon(int messageId, RequestControl[] controls) throws LdapException {
        AbandonRequest ar = Requests.newAbandonRequest((int)messageId);
        if (controls != null) {
            for (Control c : (Control[])this.config.getControlProcessor().processRequestControls(controls)) {
                ar.addControl(c);
            }
        }
        this.connection.abandonAsync(ar);
    }

    public Response<?> extendedOperation(org.ldaptive.extended.ExtendedRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            GenericExtendedResult result;
            byte[] requestBerValue = request.encode();
            GenericExtendedRequest er = requestBerValue == null ? Requests.newGenericExtendedRequest((String)request.getOID()) : Requests.newGenericExtendedRequest((String)request.getOID(), (Object)ByteString.wrap((byte[])requestBerValue));
            if (request.getControls() != null) {
                for (Control c : (Control[])this.config.getControlProcessor().processRequestControls((RequestControl[])request.getControls())) {
                    er.addControl(c);
                }
            }
            byte[] responseBerValue = (result = (GenericExtendedResult)this.connection.extendedRequest((ExtendedRequest)er)).getValue() != null ? result.getValue().toByteArray() : null;
            ExtendedResponse extRes = ExtendedResponseFactory.createExtendedResponse((String)request.getOID(), (String)result.getOID(), (byte[])responseBerValue);
            response = this.createResponse((Request)request, extRes.getValue(), (Result)result);
        }
        catch (ErrorResultException e) {
            this.processErrorResultException((Request)request, e);
        }
        return response;
    }

    public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        this.notificationListener.addUnsolicitedNotificationListener(listener);
    }

    public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        this.notificationListener.removeUnsolicitedNotificationListener(listener);
    }

    protected <T> Response<T> createResponse(Request request, T result, Result ldapResult) {
        List ctls = ldapResult.getControls();
        List urls = ldapResult.getReferralURIs();
        return new Response(result, ResultCode.valueOf((int)ldapResult.getResultCode().intValue()), ldapResult.getDiagnosticMessage(), ldapResult.getMatchedDN(), this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()])), urls.toArray(new String[urls.size()]), -1);
    }

    protected void processErrorResultException(Request request, ErrorResultException e) throws LdapException {
        List ctls = e.getResult().getControls();
        List urls = e.getResult().getReferralURIs();
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (Exception)((Object)e), (int)e.getResult().getResultCode().intValue(), (String)e.getResult().getMatchedDN(), (ResponseControl[])this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()])), (String[])urls.toArray(new String[urls.size()]), (boolean)true);
    }

    protected class AggregateUnsolicitedNotificationListener
    implements ConnectionEventListener {
        private final List<UnsolicitedNotificationListener> listeners = new ArrayList<UnsolicitedNotificationListener>();

        protected AggregateUnsolicitedNotificationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            List<UnsolicitedNotificationListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
            List<UnsolicitedNotificationListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        public void handleConnectionClosed() {
        }

        public void handleConnectionError(boolean b, ErrorResultException e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleUnsolicitedNotification(ExtendedResult extendedResult) {
            OpenDJConnection.this.logger.debug("Unsolicited notification received: {}", (Object)extendedResult);
            List<UnsolicitedNotificationListener> list = this.listeners;
            synchronized (list) {
                Response<Object> response = OpenDJConnection.this.createResponse(null, null, (Result)extendedResult);
                for (UnsolicitedNotificationListener listener : this.listeners) {
                    listener.notificationReceived(extendedResult.getOID(), response);
                }
            }
        }
    }

    protected class OpenDJAsyncRequest
    implements AsyncRequest {
        private final FutureResult<Result> result;

        public OpenDJAsyncRequest(FutureResult<Result> r) {
            this.result = r;
        }

        public int getMessageId() {
            return this.result.getRequestID();
        }

        public void abandon() throws LdapException {
            AbandonRequest ar = Requests.newAbandonRequest((int)this.result.getRequestID());
            OpenDJConnection.this.connection.abandonAsync(ar);
        }

        public void abandon(RequestControl[] controls) throws LdapException {
            AbandonRequest ar = Requests.newAbandonRequest((int)this.result.getRequestID());
            if (controls != null) {
                for (Control c : (Control[])OpenDJConnection.this.config.getControlProcessor().processRequestControls(controls)) {
                    ar.addControl(c);
                }
            }
            OpenDJConnection.this.connection.abandonAsync(ar);
        }
    }

    protected abstract class AbstractOpenDJSearch {
        protected final SearchRequest request;
        protected final OpenDJUtils util;

        public AbstractOpenDJSearch(SearchRequest sr) {
            this.request = sr;
            this.util = new OpenDJUtils(this.request.getSortBehavior());
            this.util.setBinaryAttributes(this.request.getBinaryAttributes());
        }

        protected org.forgerock.opendj.ldap.requests.SearchRequest getSearchRequest(SearchRequest sr) {
            org.forgerock.opendj.ldap.requests.SearchRequest opendjSr = Requests.newSearchRequest((String)sr.getBaseDn(), (org.forgerock.opendj.ldap.SearchScope)this.getSearchScope(sr.getSearchScope()), (String)(sr.getSearchFilter() != null ? sr.getSearchFilter().format() : null), (String[])sr.getReturnAttributes());
            opendjSr.setDereferenceAliasesPolicy(this.getDereferencePolicy(sr.getDerefAliases()));
            opendjSr.setSizeLimit((int)sr.getSizeLimit());
            opendjSr.setTimeLimit((int)sr.getTimeLimit());
            opendjSr.setTypesOnly(sr.getTypesOnly());
            return opendjSr;
        }

        protected org.forgerock.opendj.ldap.SearchScope getSearchScope(SearchScope ss) {
            org.forgerock.opendj.ldap.SearchScope scope = null;
            if (ss == SearchScope.OBJECT) {
                scope = org.forgerock.opendj.ldap.SearchScope.BASE_OBJECT;
            } else if (ss == SearchScope.ONELEVEL) {
                scope = org.forgerock.opendj.ldap.SearchScope.SINGLE_LEVEL;
            } else if (ss == SearchScope.SUBTREE) {
                scope = org.forgerock.opendj.ldap.SearchScope.WHOLE_SUBTREE;
            }
            return scope;
        }

        protected DereferenceAliasesPolicy getDereferencePolicy(DerefAliases deref) {
            DereferenceAliasesPolicy policy = DereferenceAliasesPolicy.NEVER;
            if (deref == DerefAliases.ALWAYS) {
                policy = DereferenceAliasesPolicy.ALWAYS;
            } else if (deref == DerefAliases.FINDING) {
                policy = DereferenceAliasesPolicy.FINDING_BASE;
            } else if (deref == DerefAliases.NEVER) {
                policy = DereferenceAliasesPolicy.NEVER;
            } else if (deref == DerefAliases.SEARCHING) {
                policy = DereferenceAliasesPolicy.IN_SEARCHING;
            }
            return policy;
        }

        protected ResultCode ignoreSearchException(ResultCode[] ignoreResultCodes, ErrorResultException e) {
            ResultCode ignore = null;
            if (ignoreResultCodes != null && ignoreResultCodes.length > 0) {
                for (ResultCode rc : ignoreResultCodes) {
                    if (e.getResult().getResultCode().intValue() != rc.value()) continue;
                    OpenDJConnection.this.logger.debug("Ignoring ldap exception", (Throwable)e);
                    ignore = rc;
                    break;
                }
            }
            return ignore;
        }

        protected SearchItem processSearchResultEntry(SearchResultEntry entry) {
            OpenDJConnection.this.logger.trace("reading search entry: {}", (Object)entry);
            ResponseControl[] respControls = null;
            if (entry.getControls() != null && entry.getControls().size() > 0) {
                List ctls = entry.getControls();
                respControls = OpenDJConnection.this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()]));
            }
            SearchEntry se = this.util.toSearchEntry((Entry)entry, respControls, -1);
            return new SearchItem(se);
        }

        protected SearchItem processSearchResultReference(SearchResultReference ref) {
            OpenDJConnection.this.logger.trace("reading search reference: {}", (Object)ref);
            ResponseControl[] respControls = null;
            if (ref.getControls() != null && ref.getControls().size() > 0) {
                List ctls = ref.getControls();
                respControls = OpenDJConnection.this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()]));
            }
            SearchReference sr = new SearchReference(-1, respControls, (Collection)ref.getURIs());
            return new SearchItem(sr);
        }

        protected SearchItem processIntermediateResponse(IntermediateResponse res) {
            OpenDJConnection.this.logger.trace("reading intermediate response: {}", (Object)res);
            ResponseControl[] respControls = null;
            if (res.getControls() != null && res.getControls().size() > 0) {
                List ctls = res.getControls();
                respControls = OpenDJConnection.this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()]));
            }
            org.ldaptive.intermediate.IntermediateResponse ir = IntermediateResponseFactory.createIntermediateResponse((String)res.getOID(), (byte[])res.getValue().toByteArray(), respControls, (int)-1);
            return new SearchItem(ir);
        }
    }

    protected class OpenDJAsyncSearchListener
    extends AbstractOpenDJSearch
    implements SearchResultHandler,
    IntermediateResponseHandler {
        private final SearchListener listener;

        public OpenDJAsyncSearchListener(SearchRequest sr, SearchListener sl) {
            super(sr);
            this.listener = sl;
        }

        public void initialize() throws LdapException {
            this.search(OpenDJConnection.this.connection, this.request);
        }

        protected void search(Connection conn, SearchRequest sr) throws LdapException {
            org.forgerock.opendj.ldap.requests.SearchRequest opendjSr = this.getSearchRequest(sr);
            if (sr.getControls() != null) {
                for (Control c : (Control[])OpenDJConnection.this.config.getControlProcessor().processRequestControls(sr.getControls())) {
                    opendjSr.addControl(c);
                }
            }
            FutureResult result = conn.searchAsync(opendjSr, (IntermediateResponseHandler)this, (SearchResultHandler)this);
            this.listener.asyncRequestReceived((AsyncRequest)new OpenDJAsyncRequest((FutureResult<Result>)result));
        }

        public void handleErrorResult(ErrorResultException e) {
            OpenDJConnection.this.logger.trace("reading error result: {}", (Throwable)e);
            List ctls = e.getResult().getControls();
            List urls = e.getResult().getReferralURIs();
            this.listener.exceptionReceived((Exception)((Object)new LdapException(e.getMessage(), new Exception(e.getCause()), ResultCode.valueOf((int)e.getResult().getResultCode().intValue()), e.getResult().getMatchedDN(), OpenDJConnection.this.config.getControlProcessor().processResponseControls((Object[])ctls.toArray(new Control[ctls.size()])), urls.toArray(new String[urls.size()]))));
        }

        public void handleResult(Result r) {
            OpenDJConnection.this.logger.trace("reading result: {}", (Object)r);
            Response<Object> response = OpenDJConnection.this.createResponse((Request)this.request, null, r);
            this.listener.responseReceived(response);
        }

        public boolean handleEntry(SearchResultEntry entry) {
            this.listener.searchItemReceived(this.processSearchResultEntry(entry));
            return true;
        }

        public boolean handleReference(SearchResultReference ref) {
            this.listener.searchItemReceived(this.processSearchResultReference(ref));
            return true;
        }

        public boolean handleIntermediateResponse(IntermediateResponse res) {
            this.listener.searchItemReceived(this.processIntermediateResponse(res));
            return true;
        }
    }

    protected class OpenDJSearchIterator
    extends AbstractOpenDJSearch
    implements SearchIterator {
        private Response<Void> response;
        private SearchResultIterator resultIterator;

        public OpenDJSearchIterator(SearchRequest sr) {
            super(sr);
        }

        public void initialize() throws LdapException {
            this.resultIterator = this.search(OpenDJConnection.this.connection, this.request);
        }

        protected SearchResultIterator search(Connection conn, SearchRequest sr) throws LdapException {
            SearchResultIterator i;
            block4: {
                org.forgerock.opendj.ldap.requests.SearchRequest opendjSr = this.getSearchRequest(sr);
                if (sr.getControls() != null) {
                    for (Control c : (Control[])OpenDJConnection.this.config.getControlProcessor().processRequestControls(sr.getControls())) {
                        opendjSr.addControl(c);
                    }
                }
                i = new SearchResultIterator();
                try {
                    conn.search(opendjSr, (SearchResultHandler)i);
                }
                catch (ErrorResultException e) {
                    ResultCode rc = this.ignoreSearchException(OpenDJConnection.this.config.getSearchIgnoreResultCodes(), e);
                    if (rc != null) break block4;
                    OpenDJConnection.this.processErrorResultException((Request)this.request, e);
                }
            }
            return i;
        }

        public boolean hasNext() throws LdapException {
            if (this.resultIterator == null || this.response != null) {
                return false;
            }
            boolean more = this.resultIterator.hasNext();
            if (!more) {
                Result result = this.resultIterator.getResult();
                OpenDJConnection.this.logger.trace("reading search result: {}", (Object)result);
                this.response = OpenDJConnection.this.createResponse((Request)this.request, null, result);
            }
            return more;
        }

        public SearchItem next() throws LdapException {
            return this.resultIterator.next();
        }

        public Response<Void> getResponse() {
            return this.response;
        }

        public void close() throws LdapException {
        }

        protected class SearchResultIterator
        implements SearchResultHandler {
            protected final Queue<SearchItem> queue = new ArrayDeque<SearchItem>();
            private Result result;

            protected SearchResultIterator() {
            }

            public SearchItem next() {
                return this.queue.poll();
            }

            public Result getResult() {
                return this.result;
            }

            public boolean hasNext() {
                return !this.queue.isEmpty();
            }

            public void handleErrorResult(ErrorResultException e) {
                OpenDJConnection.this.logger.trace("reading error result: {}", (Throwable)e);
                this.result = e.getResult();
            }

            public void handleResult(Result r) {
                OpenDJConnection.this.logger.trace("reading result: {}", (Object)r);
                this.result = r;
            }

            public boolean handleEntry(SearchResultEntry entry) {
                return this.queue.add(OpenDJSearchIterator.this.processSearchResultEntry(entry));
            }

            public boolean handleReference(SearchResultReference ref) {
                return this.queue.add(OpenDJSearchIterator.this.processSearchResultReference(ref));
            }
        }
    }
}

