/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.opendj;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.opendj.OpenDJConnection;
import org.ldaptive.provider.opendj.OpenDJProviderConfig;

public class OpenDJConnectionFactory
extends AbstractProviderConnectionFactory<OpenDJProviderConfig> {
    private final LDAPOptions ldapOptions;

    public OpenDJConnectionFactory(String url, OpenDJProviderConfig config, LDAPOptions options) {
        super(url, (ProviderConfig)config);
        this.ldapOptions = options;
    }

    protected OpenDJConnection createInternal(String url) throws LdapException {
        LdapURL ldapUrl = new LdapURL(url);
        OpenDJConnection conn = null;
        boolean closeConn = false;
        try {
            LDAPConnectionFactory cf = new LDAPConnectionFactory(ldapUrl.getLastEntry().getHostname(), ldapUrl.getLastEntry().getPort(), this.ldapOptions);
            Connection c = cf.getConnection();
            conn = new OpenDJConnection(c, (OpenDJProviderConfig)this.getProviderConfig());
        }
        catch (ErrorResultException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e), ResultCode.valueOf((int)e.getResult().getResultCode().intValue()));
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }
}

