/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.opendj;

import java.util.Arrays;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.ControlHandler;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.opendj.OpenDJControlHandler;

public class OpenDJProviderConfig
extends ProviderConfig<Control> {
    private LDAPOptions options;
    private ResultCode[] searchIgnoreResultCodes;

    public OpenDJProviderConfig() {
        this.setOperationExceptionResultCodes(new ResultCode[]{ResultCode.SERVER_DOWN});
        this.setControlProcessor(new ControlProcessor((ControlHandler)new OpenDJControlHandler()));
        this.searchIgnoreResultCodes = new ResultCode[]{ResultCode.TIME_LIMIT_EXCEEDED, ResultCode.SIZE_LIMIT_EXCEEDED, ResultCode.REFERRAL};
    }

    public LDAPOptions getOptions() {
        return this.options;
    }

    public void setOptions(LDAPOptions o) {
        this.options = o;
    }

    public ResultCode[] getSearchIgnoreResultCodes() {
        return this.searchIgnoreResultCodes;
    }

    public void setSearchIgnoreResultCodes(ResultCode[] codes) {
        this.checkImmutable();
        this.logger.trace("setting searchIgnoreResultCodes: {}", (Object)Arrays.toString(codes));
        this.searchIgnoreResultCodes = codes;
    }

    public String toString() {
        return String.format("[%s@%d::operationExceptionResultCodes=%s, properties=%s, connectionStrategy=%s, controlProcessor=%s, options=%s, searchIgnoreResultCodes=%s]", ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).hashCode(), Arrays.toString(this.getOperationExceptionResultCodes()), this.getProperties(), this.getConnectionStrategy(), this.getControlProcessor(), this.options, Arrays.toString(this.searchIgnoreResultCodes));
    }
}

