/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.opendj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.SortKey;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchEntry;
import org.ldaptive.SortBehavior;
import org.ldaptive.control.ResponseControl;

public class OpenDJUtils {
    private final SortBehavior sortBehavior;
    private List<String> binaryAttrs;

    public OpenDJUtils() {
        this.sortBehavior = SortBehavior.getDefaultSortBehavior();
    }

    public OpenDJUtils(SortBehavior sb) {
        this.sortBehavior = sb;
    }

    public List<String> getBinaryAttributes() {
        return this.binaryAttrs;
    }

    public void setBinaryAttributes(String[] s) {
        if (s != null) {
            this.binaryAttrs = Arrays.asList(s);
        }
    }

    public ByteString[] fromStringValues(Collection<String> values) {
        ByteString[] bstrings = new ByteString[values.size()];
        int i = 0;
        for (String s : values) {
            ByteStringBuilder builder = new ByteStringBuilder(s.length());
            builder.append(s);
            bstrings[i++] = builder.toByteString();
        }
        return bstrings;
    }

    public ByteString[] fromBinaryValues(Collection<byte[]> values) {
        ByteString[] bstrings = new ByteString[values.size()];
        int i = 0;
        for (byte[] b : values) {
            ByteStringBuilder builder = new ByteStringBuilder(b.length);
            builder.append(b);
            bstrings[i++] = builder.toByteString();
        }
        return bstrings;
    }

    public String[] toStringValues(ByteString[] values) {
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = values[i].toString();
        }
        return strings;
    }

    public byte[][] toBinaryValues(ByteString[] values) {
        byte[][] bytes = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            bytes[i] = values[i].toByteArray();
        }
        return bytes;
    }

    public Attribute fromLdapAttribute(LdapAttribute la) {
        LinkedAttribute attribute = la.isBinary() ? new LinkedAttribute(la.getName(), (Object[])this.fromBinaryValues(la.getBinaryValues())) : new LinkedAttribute(la.getName(), (Object[])this.fromStringValues(la.getStringValues()));
        return attribute;
    }

    public LdapAttribute toLdapAttribute(Attribute a) {
        boolean isBinary = false;
        if (a.getAttributeDescriptionAsString().contains(";binary")) {
            isBinary = true;
        } else if (this.binaryAttrs != null && this.binaryAttrs.contains(a.getAttributeDescriptionAsString())) {
            isBinary = true;
        }
        LdapAttribute la = new LdapAttribute(this.sortBehavior, isBinary);
        la.setName(a.getAttributeDescriptionAsString());
        if (isBinary) {
            la.addBinaryValue(this.toBinaryValues(a.toArray()));
        } else {
            la.addStringValue(this.toStringValues(a.toArray()));
        }
        return la;
    }

    public Attribute[] fromLdapAttributes(Collection<LdapAttribute> c) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (LdapAttribute a : c) {
            attributes.add(this.fromLdapAttribute(a));
        }
        return attributes.toArray(new Attribute[attributes.size()]);
    }

    public Entry fromLdapEntry(LdapEntry le) {
        LinkedHashMapEntry entry = new LinkedHashMapEntry();
        entry.setName(DN.valueOf((String)le.getDn()));
        for (LdapAttribute la : le.getAttributes()) {
            entry.addAttribute(this.fromLdapAttribute(la), null);
        }
        return entry;
    }

    public SearchEntry toSearchEntry(Entry e, ResponseControl[] c, int id) {
        SearchEntry se = new SearchEntry(id, c, this.sortBehavior);
        se.setDn(e.getName().toString());
        for (Attribute a : e.getAllAttributes()) {
            se.addAttribute(new LdapAttribute[]{this.toLdapAttribute(a)});
        }
        return se;
    }

    public Modification[] fromAttributeModification(AttributeModification[] am) {
        Modification[] mods = new Modification[am.length];
        for (int i = 0; i < am.length; ++i) {
            Attribute a = this.fromLdapAttribute(am[i].getAttribute());
            mods[i] = am[i].getAttribute().isBinary() ? new Modification(OpenDJUtils.getModificationType(am[i].getAttributeModificationType()), a) : new Modification(OpenDJUtils.getModificationType(am[i].getAttributeModificationType()), a);
        }
        return mods;
    }

    public static SortKey[] fromSortKey(org.ldaptive.control.SortKey[] sk) {
        SortKey[] keys = null;
        if (sk != null) {
            keys = new SortKey[sk.length];
            for (int i = 0; i < sk.length; ++i) {
                keys[i] = new SortKey(sk[i].getAttributeDescription(), sk[i].getReverseOrder(), sk[i].getMatchingRuleId());
            }
        }
        return keys;
    }

    protected static ModificationType getModificationType(AttributeModificationType am) {
        ModificationType type = null;
        if (am == AttributeModificationType.ADD) {
            type = ModificationType.ADD;
        } else if (am == AttributeModificationType.REMOVE) {
            type = ModificationType.DELETE;
        } else if (am == AttributeModificationType.REPLACE) {
            type = ModificationType.REPLACE;
        }
        return type;
    }
}

