/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.templates;

import java.util.Arrays;
import java.util.Collection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.ldaptive.SortBehavior;
import org.ldaptive.concurrent.AggregatePooledSearchExecutor;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.templates.Query;
import org.ldaptive.templates.SearchTemplates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTemplatesExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private AggregatePooledSearchExecutor searchExecutor;
    private PooledConnectionFactory[] connectionFactories;
    private SearchTemplates[] searchTemplates;

    public SearchTemplatesExecutor() {
    }

    public SearchTemplatesExecutor(AggregatePooledSearchExecutor executor, PooledConnectionFactory[] factories, SearchTemplates ... templates) {
        this.searchExecutor = executor;
        this.connectionFactories = factories;
        this.searchTemplates = templates;
    }

    public AggregatePooledSearchExecutor getSearchExecutor() {
        return this.searchExecutor;
    }

    public void setSearchExecutor(AggregatePooledSearchExecutor executor) {
        this.searchExecutor = executor;
    }

    public PooledConnectionFactory[] getConnectionFactories() {
        return this.connectionFactories;
    }

    public void setConnectionFactories(PooledConnectionFactory[] factories) {
        this.connectionFactories = factories;
    }

    public SearchTemplates[] getSearchTemplates() {
        return this.searchTemplates;
    }

    public void setSearchTemplates(SearchTemplates[] templates) {
        this.searchTemplates = templates;
    }

    public SearchResult search(Query query) throws LdapException {
        this.logger.debug("Query: {}", (Object)query);
        SearchTemplates templates = null;
        if (query.getTerms().length > 0) {
            this.logger.debug("Processing query: {}", (Object)Arrays.toString(query.getTerms()));
            int termCount = query.getTerms().length;
            if (termCount > this.searchTemplates.length) {
                termCount = this.searchTemplates.length;
            }
            if (termCount > 0) {
                templates = this.searchTemplates[termCount - 1];
                if (templates != null) {
                    this.logger.debug("Found search templates {} for term count of {}", (Object)templates, (Object)termCount);
                } else {
                    this.logger.debug("No search module found for term count of {}", (Object)termCount);
                }
            } else {
                this.logger.debug("No terms found in query {}", (Object)query);
            }
        }
        if (templates != null) {
            return this.search(templates.format(query), query.getReturnAttributes(), query.getFromResult(), query.getToResult());
        }
        return null;
    }

    protected SearchResult search(SearchFilter[] filters, String[] returnAttrs, Integer fromResult, Integer toResult) throws LdapException {
        this.logger.debug("Performing search with {} filters", (Object)Arrays.toString(filters));
        Collection responses = this.searchExecutor.search((ConnectionFactory[])this.connectionFactories, filters, returnAttrs);
        SearchResult result = new SearchResult(SortBehavior.ORDERED);
        for (Response r : responses) {
            for (LdapEntry le : ((SearchResult)r.getResult()).getEntries()) {
                result.addEntry(new LdapEntry[]{le});
                this.logger.debug("Search found: {}", (Object)le.getDn());
            }
        }
        SearchResult subResult = fromResult != null ? (toResult != null ? result.subResult(fromResult.intValue(), toResult.intValue()) : result.subResult(fromResult.intValue(), result.size())) : (toResult != null ? result.subResult(0, toResult.intValue()) : result);
        return subResult;
    }

    public void close() {
        if (this.connectionFactories != null) {
            for (PooledConnectionFactory factory : this.connectionFactories) {
                factory.getConnectionPool().close();
            }
        }
    }

    public String toString() {
        return String.format("[%s@%d::searchExecutor=%s, connectionFactories=%s, searchTemplates=%s]", this.getClass().getName(), this.hashCode(), this.searchExecutor, Arrays.toString(this.connectionFactories), Arrays.toString(this.searchTemplates));
    }
}

