/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.templates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.SearchFilter;
import org.ldaptive.templates.Query;

public class SearchTemplates {
    private final String[] filterTemplates;
    private String searchRestrictions;
    private TermParser[] termParsers = new TermParser[]{new DefaultTermParser(), new InitialTermParser()};

    public SearchTemplates(String ... templates) {
        this.filterTemplates = templates;
    }

    public String getSearchRestrictions() {
        return this.searchRestrictions;
    }

    public void setSearchRestrictions(String restrictions) {
        this.searchRestrictions = restrictions;
    }

    public TermParser[] getTermParsers() {
        return this.termParsers;
    }

    public void setTermParsers(TermParser ... parsers) {
        this.termParsers = parsers;
    }

    public SearchFilter[] format(Query query) {
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>(this.filterTemplates.length);
        for (String template : this.filterTemplates) {
            SearchFilter filter = new SearchFilter(this.concatFilters(template, query.getSearchRestrictions(), this.searchRestrictions));
            for (TermParser parser : this.termParsers) {
                for (Map.Entry<String, String> e : parser.parse(query.getTerms()).entrySet()) {
                    filter.setParameter(e.getKey(), (Object)e.getValue());
                }
            }
            filters.add(filter);
        }
        return filters.toArray(new SearchFilter[filters.size()]);
    }

    private String concatFilters(String ... filters) {
        ArrayList<String> nonNullFilters = new ArrayList<String>(filters.length);
        for (String s : filters) {
            if (s == null) continue;
            nonNullFilters.add(s);
        }
        if (nonNullFilters.size() > 1) {
            StringBuilder sb = new StringBuilder("(&");
            nonNullFilters.forEach(sb::append);
            sb.append(")");
            return sb.toString();
        }
        return (String)nonNullFilters.get(0);
    }

    public String toString() {
        return String.format("[%s@%d::filterTemplates=%s, searchRestrictions=%s, termParsers=%s]", this.getClass().getName(), this.hashCode(), Arrays.toString(this.filterTemplates), this.searchRestrictions, Arrays.toString(this.termParsers));
    }

    public class InitialTermParser
    implements TermParser {
        @Override
        public Map<String, String> parse(String[] terms) {
            HashMap<String, String> filterParams = new HashMap<String, String>(terms.length);
            String[] initialParams = this.getInitials(terms);
            for (int i = 1; i <= initialParams.length; ++i) {
                filterParams.put("initial" + i, initialParams[i - 1]);
            }
            return filterParams;
        }

        private String[] getInitials(String[] names) {
            String[] initials = new String[names.length];
            for (int i = 0; i < initials.length; ++i) {
                initials[i] = names[i] != null && names[i].length() > 0 ? names[i].substring(0, 1) : null;
            }
            return initials;
        }
    }

    public class DefaultTermParser
    implements TermParser {
        @Override
        public Map<String, String> parse(String[] terms) {
            HashMap<String, String> filterParams = new HashMap<String, String>(terms.length);
            for (int i = 1; i <= terms.length; ++i) {
                filterParams.put("term" + i, terms[i - 1]);
            }
            return filterParams;
        }
    }

    public static interface TermParser {
        public Map<String, String> parse(String[] var1);
    }
}

