/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.servlets;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.ldaptive.concurrent.SearchOperationWorker;
import org.ldaptive.servlets.ServletSearchOperation;
import org.ldaptive.templates.Query;
import org.ldaptive.templates.SearchTemplates;
import org.ldaptive.templates.SearchTemplatesOperation;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractServletSearchTemplatesOperation
extends SearchTemplatesOperation
implements ServletSearchOperation {
    private static final String SPRING_CONTEXT_PATH = "springContextPath";
    private static final String DEFAULT_SPRING_CONTEXT_PATH = "/templates-context.xml";
    private static final String IGNORE_PATTERN = "ignorePattern";
    private static final String MINIMUM_QUERY_TERM_LENGTH = "minimumQueryTermLength";
    private Pattern ignorePattern;
    private int minimumQueryTermLength;

    public void initialize(ServletConfig config) {
        String springContextPath = config.getInitParameter(SPRING_CONTEXT_PATH) != null ? config.getInitParameter(SPRING_CONTEXT_PATH) : DEFAULT_SPRING_CONTEXT_PATH;
        this.logger.debug("{} = {}", (Object)SPRING_CONTEXT_PATH, (Object)springContextPath);
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(springContextPath);
        SearchOperationWorker search = (SearchOperationWorker)context.getBean(SearchOperationWorker.class);
        ((SearchOperation)search.getOperation()).setConnectionFactory((ConnectionFactory)context.getBean(ConnectionFactory.class));
        this.setSearchOperationWorker(search);
        this.logger.debug("searchExecutor = {}", (Object)this.getSearchOperationWorker());
        Map templates = context.getBeansOfType(SearchTemplates.class);
        this.setSearchTemplates(templates.values().toArray(new SearchTemplates[0]));
        this.logger.debug("searchTemplates = {}", (Object)Arrays.toString(this.getSearchTemplates()));
        this.ignorePattern = config.getInitParameter(IGNORE_PATTERN) != null ? Pattern.compile(config.getInitParameter(IGNORE_PATTERN)) : null;
        this.logger.debug("{} = {}", (Object)IGNORE_PATTERN, (Object)this.ignorePattern);
        this.minimumQueryTermLength = config.getInitParameter(MINIMUM_QUERY_TERM_LENGTH) != null ? Integer.parseInt(config.getInitParameter(MINIMUM_QUERY_TERM_LENGTH)) : 0;
        this.logger.debug("{} = {}", (Object)MINIMUM_QUERY_TERM_LENGTH, (Object)this.minimumQueryTermLength);
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher;
        Integer fromResult = null;
        if (request.getParameter("from-result") != null) {
            try {
                fromResult = Integer.valueOf(request.getParameter("from-result"));
            }
            catch (NumberFormatException e) {
                this.logger.warn("Received invalid fromResult parameter: {}", (Object)request.getParameter("from-result"));
            }
        }
        Integer toResult = null;
        if (request.getParameter("to-result") != null) {
            try {
                toResult = Integer.valueOf(request.getParameter("to-result"));
            }
            catch (NumberFormatException e) {
                this.logger.warn("Received invalid toResult parameter: {}", (Object)request.getParameter("to-result"));
            }
        }
        boolean doSearch = true;
        String queryString = request.getParameter("query");
        if (queryString == null || queryString.length() == 0) {
            this.logger.info("Ignoring empty query");
            doSearch = false;
        }
        if (doSearch && this.ignorePattern != null && (matcher = this.ignorePattern.matcher(queryString)).matches()) {
            this.logger.info("Ignoring query {}", (Object)queryString);
            doSearch = false;
        }
        if (doSearch) {
            Query query = new Query(queryString);
            if (this.minimumQueryTermLength > 0) {
                boolean hasMinimumLengthQueryTerm = false;
                for (String term : query.getTerms()) {
                    if (term.length() < this.minimumQueryTermLength) continue;
                    hasMinimumLengthQueryTerm = true;
                    break;
                }
                if (!hasMinimumLengthQueryTerm) {
                    this.logger.info("Does not meet minimum query term length {}", (Object)queryString);
                    doSearch = false;
                }
            }
            if (doSearch) {
                query.setReturnAttributes(request.getParameterValues("attrs"));
                query.setSearchRestrictions(request.getParameter("search-restrictions"));
                query.setFromResult(fromResult);
                query.setToResult(toResult);
                this.logger.info("Performing query {}", (Object)query);
                SearchResponse result = this.execute(query);
                this.writeResponse(result, response);
            }
        }
    }

    protected abstract void writeResponse(SearchResponse var1, HttpServletResponse var2) throws IOException;
}

