/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.PrintStream;
import org.leadpony.justify.cli.Message;

class Console {
    private final PrintStream stdout;
    private final PrintStream stderr;

    Console(PrintStream out, PrintStream err) {
        this.stdout = out;
        this.stderr = err;
    }

    Console withColor(Color color) {
        return this;
    }

    Console print() {
        this.stdout.println();
        return this;
    }

    Console print(String line) {
        this.stdout.println(this.decorate(line));
        return this;
    }

    Console print(Message message) {
        return this.print(message.toString());
    }

    Console print(Message message, Object ... arguments) {
        return this.print(message.format(arguments));
    }

    Console print(Exception exception) {
        this.print(exception.getLocalizedMessage());
        return this;
    }

    Console error(String line) {
        this.stderr.println(this.decorate(line));
        return this;
    }

    Console error(Exception exception) {
        return this.error(exception.getLocalizedMessage());
    }

    protected String decorate(String line) {
        return line;
    }

    static enum Color {
        DEFAULT(""),
        SUCCESS("\u001b[92m"),
        WARNING("\u001b[93m"),
        DANGER("\u001b[91m");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        String code() {
            return this.code;
        }
    }
}

