/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.leadpony.justify.cli.AbstractCommand;
import org.leadpony.justify.cli.Console;
import org.leadpony.justify.cli.Option;
import org.leadpony.justify.cli.Status;
import org.leadpony.justify.cli.ValidateOption;

class Help
extends AbstractCommand {
    private static final String BUNDLE_BASE_NAME = "org.leadpony.justify.cli.usage";
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.leadpony.justify.cli.usage", Locale.getDefault());

    Help(Console console) {
        super(console);
    }

    @Override
    public Status execute(List<String> args) {
        this.printUsage();
        return Status.VALID;
    }

    private String getMessage(String key) {
        return this.bundle.getString(key);
    }

    private void printUsage() {
        this.console.print(this.getMessage("title"));
        this.console.print(this.getMessage("usage"));
        this.console.print("  " + this.getMessage("command"));
        this.console.print();
        this.printAllOptions();
    }

    private void printAllOptions() {
        this.console.print(this.getMessage("options"));
        List<Option> options = Help.sortOptions(ValidateOption.values());
        for (Option option : options) {
            this.printOption(option);
        }
    }

    private void printOption(Option option) {
        String name = option.toString();
        StringBuilder builder = new StringBuilder();
        builder.append("  ").append(option.preferredName());
        if (option.requiresArgument()) {
            String arg = this.getMessage(name + ".arg");
            builder.append(" <").append(arg).append(">");
            if (option.takesMultipleArguments()) {
                builder.append(" ...");
            }
        }
        if (option.isRequired()) {
            builder.append(" *").append(this.getMessage("required"));
        }
        this.console.print(builder.toString());
        this.console.print(Help.formatDescription(this.getMessage(name)));
    }

    private static String formatDescription(String description) {
        String replaced = description.replaceAll("\n", "\n      ");
        return "      " + replaced;
    }

    private static List<Option> sortOptions(Option[] options) {
        ArrayList<Option> sorted = new ArrayList<Option>(Arrays.asList(options));
        Collections.sort(sorted, Help::compareOption);
        return sorted;
    }

    private static int compareOption(Option a, Option b) {
        return a.preferredName().compareTo(b.preferredName());
    }
}

