/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import org.leadpony.justify.cli.LocalLocation;
import org.leadpony.justify.cli.RemoteLocation;

interface Location {
    public static Location at(String location) {
        Objects.requireNonNull(location, "location must not be null.");
        if (location.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Matcher m = RemoteLocation.URL_PATTERN.matcher(location);
        if (m.lookingAt()) {
            try {
                return new RemoteLocation(new URL(location));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            return new LocalLocation(Paths.get(location, new String[0]));
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public InputStream openStream() throws IOException;

    default public Location resolve(Location other) {
        return other;
    }

    public URL toURL() throws MalformedURLException;
}

