/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonReader;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import javax.json.stream.JsonParsingException;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.JsonSchemaReaderFactory;
import org.leadpony.justify.api.JsonSchemaResolver;
import org.leadpony.justify.api.JsonValidatingException;
import org.leadpony.justify.api.JsonValidationService;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.cli.AbstractCommand;
import org.leadpony.justify.cli.CommandException;
import org.leadpony.justify.cli.Console;
import org.leadpony.justify.cli.Location;
import org.leadpony.justify.cli.Message;
import org.leadpony.justify.cli.Option;
import org.leadpony.justify.cli.Problems;
import org.leadpony.justify.cli.SchemaCatalog;
import org.leadpony.justify.cli.Status;
import org.leadpony.justify.cli.ValidateOption;

class Validate
extends AbstractCommand {
    private final JsonValidationService service = JsonValidationService.newInstance();
    private final JsonParserFactory parserFactory = Json.createParserFactory(null);
    private final ProblemHandler problemPrinter = this.service.createProblemPrinter(console::print);
    private final Catalog catalog = new Catalog();

    Validate(Console console) {
        super(console);
    }

    @Override
    public Status execute(List<String> args) {
        this.parseCommandArguments(args);
        this.populateCatalog();
        this.validateAll();
        return this.getStatus();
    }

    private void validateAll() {
        Location location = (Location)this.getOptionValue(ValidateOption.SCHEMA);
        List<?> instances = this.getOptionValues(ValidateOption.INSTANCE);
        JsonSchema schema = this.readSchemaAt(location);
        if (schema != null) {
            for (Location instance : instances) {
                this.validateInstanceAt(instance, schema);
            }
        } else if (!instances.isEmpty()) {
            throw new CommandException(Message.SCHEMA_FAILED, new Object[0]);
        }
    }

    private JsonSchema readSchemaAt(Location location) {
        this.console.print(Message.VALIDATE_SCHEMA, location);
        return this.validateSchemaAt(location);
    }

    private JsonSchema validateSchemaAt(Location location) {
        JsonSchema jsonSchema;
        block10: {
            JsonSchemaReaderFactory factory = this.createSchemaReaderFactory();
            JsonSchemaReader reader = factory.createSchemaReader(Validate.openSchema(location));
            try {
                JsonSchema schema = reader.read();
                this.console.withColor(Console.Color.SUCCESS).print(Message.SCHEMA_VALID, location);
                jsonSchema = schema;
                if (reader == null) break block10;
            }
            catch (Throwable schema) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            schema.addSuppressed(throwable);
                        }
                    }
                    throw schema;
                }
                catch (JsonValidatingException e) {
                    List problems = e.getProblems();
                    this.problemPrinter.handleProblems(problems);
                    this.console.withColor(Console.Color.DANGER).print(Message.SCHEMA_INVALID, location, Problems.countLeast(problems));
                    this.setStatus(Status.INVALID);
                    return null;
                }
                catch (JsonParsingException e) {
                    this.console.withColor(Console.Color.DANGER).print(Message.SCHEMA_MALFORMED, new Object[]{e});
                    this.setStatus(Status.INVALID);
                    return null;
                }
                catch (JsonException e) {
                    throw new CommandException(e);
                }
            }
            reader.close();
        }
        return jsonSchema;
    }

    private JsonSchemaReaderFactory createSchemaReaderFactory() {
        boolean strict = this.containsOption(ValidateOption.STRICT);
        return this.service.createSchemaReaderFactoryBuilder().withCustomFormatAttributes(false).withStrictKeywords(strict).withStrictFormats(strict).withSchemaResolver((JsonSchemaResolver)this.catalog).build();
    }

    private void validateInstanceAt(Location location, JsonSchema schema) {
        this.console.print(Message.VALIDATE_INSTANCE, location);
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ProblemHandler handler = this.createProblemHandler(problems);
        try (JsonReader reader = this.service.createReader(Validate.openInstance(location), schema, handler);){
            reader.readValue();
        }
        catch (JsonParsingException e) {
            this.console.withColor(Console.Color.DANGER).print(Message.INSTANCE_MALFORMED, new Object[]{e});
            this.setStatus(Status.INVALID);
            return;
        }
        catch (JsonException e) {
            throw new CommandException(e);
        }
        if (problems.isEmpty()) {
            this.console.withColor(Console.Color.SUCCESS).print(Message.INSTANCE_VALID, location);
        } else {
            this.console.withColor(Console.Color.DANGER).print(Message.INSTANCE_INVALID, location, Problems.countLeast(problems));
            this.setStatus(Status.INVALID);
        }
    }

    private void populateCatalog() {
        List<?> refs;
        Location catalog = (Location)this.getOptionValue(ValidateOption.CATALOG);
        if (catalog != null) {
            this.readSchemaCatalogAt(catalog);
        }
        if ((refs = this.getOptionValues(ValidateOption.REFERENCE)) != null) {
            for (Location ref : refs) {
                this.addReferencedSchema(ref);
            }
        }
    }

    private void readSchemaCatalogAt(Location location) {
        this.console.print(Message.READ_CATALOG, location);
        JsonSchema schema = this.readSchemaFromResource("catalog.schema.json");
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ProblemHandler handler = this.createProblemHandler(problems);
        try (JsonParser parser = this.service.createParser(Validate.openCatalog(location), schema, handler);){
            this.parseCatalog(parser, location);
            if (!problems.isEmpty()) {
                this.console.withColor(Console.Color.DANGER).print(Message.CATALOG_INVALID, location, Problems.countLeast(problems));
                throw new CommandException(Message.CATALOG_FAILED, new Object[0]);
            }
        }
        catch (JsonParsingException e) {
            this.console.withColor(Console.Color.DANGER).print(Message.CATALOG_MALFORMED, new Object[]{e});
            throw new CommandException(Message.CATALOG_FAILED, new Object[0]);
        }
        catch (JsonException e) {
            throw new CommandException(e);
        }
    }

    private JsonSchema readSchemaFromResource(String name) {
        JsonSchema jsonSchema;
        block8: {
            InputStream in = this.getClass().getResourceAsStream(name);
            try {
                jsonSchema = this.service.readSchema(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CommandException(e);
                }
            }
            in.close();
        }
        return jsonSchema;
    }

    private void parseCatalog(JsonParser parser, Location location) {
        if (!parser.hasNext() || parser.next() != JsonParser.Event.START_OBJECT) {
            return;
        }
        URI id = null;
        while (parser.hasNext()) {
            switch (parser.next()) {
                case KEY_NAME: {
                    try {
                        id = new URI(parser.getString());
                    }
                    catch (URISyntaxException e) {
                        id = null;
                    }
                    break;
                }
                case VALUE_STRING: {
                    try {
                        Location value = Location.at(parser.getString());
                        if (id == null) break;
                        this.catalog.put(id, location.resolve(value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
                case START_ARRAY: {
                    parser.skipArray();
                }
                case START_OBJECT: {
                    parser.skipObject();
                }
            }
        }
    }

    private void addReferencedSchema(Location location) {
        this.console.print(Message.INSPECT_SCHEMA, location);
        URI id = this.identifySchema(location);
        if (id != null) {
            this.console.print(Message.SCHEMA_ID_FOUND, id);
            this.catalog.put(id, location);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI identifySchema(Location location) {
        try (JsonParser parser = this.parserFactory.createParser(Validate.openSchema(location));){
            if (parser.hasNext() && parser.next() == JsonParser.Event.START_OBJECT) {
                while (parser.hasNext()) {
                    switch (parser.next()) {
                        case KEY_NAME: {
                            if (!parser.getString().equals("$id")) break;
                            URI uRI = this.extractSchemaId(parser);
                            return uRI;
                        }
                        case START_ARRAY: {
                            parser.skipArray();
                        }
                        case START_OBJECT: {
                            parser.skipObject();
                            break;
                        }
                    }
                }
            }
            this.console.withColor(Console.Color.WARNING).print(Message.SCHEMA_ID_MISSING);
            URI uRI = null;
            return uRI;
        }
        catch (JsonParsingException e) {
            this.console.withColor(Console.Color.DANGER).print(Message.SCHEMA_MALFORMED, new Object[]{e});
            return null;
        }
        catch (JsonException e) {
            throw new CommandException(e);
        }
    }

    private URI extractSchemaId(JsonParser parser) {
        if (parser.next() == JsonParser.Event.VALUE_STRING) {
            try {
                return new URI(parser.getString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        this.console.withColor(Console.Color.WARNING).print(Message.SCHEMA_ID_INVALID);
        return null;
    }

    private static InputStream openSchema(Location location) {
        try {
            return location.openStream();
        }
        catch (NoSuchFileException e) {
            throw new CommandException(Message.SCHEMA_NOT_FOUND, location);
        }
        catch (IOException e) {
            throw new CommandException(Message.ACCESS_FAILED, location);
        }
    }

    private static InputStream openInstance(Location location) {
        try {
            return location.openStream();
        }
        catch (NoSuchFileException e) {
            throw new CommandException(Message.INSTANCE_NOT_FOUND, location);
        }
        catch (IOException e) {
            throw new CommandException(Message.ACCESS_FAILED, location);
        }
    }

    private static InputStream openCatalog(Location location) {
        try {
            return location.openStream();
        }
        catch (NoSuchFileException e) {
            throw new CommandException(Message.CATALOG_NOT_FOUND, location);
        }
        catch (IOException e) {
            throw new CommandException(Message.ACCESS_FAILED, location);
        }
    }

    private ProblemHandler createProblemHandler(List<Problem> problems) {
        return found -> {
            problems.addAll(found);
            this.problemPrinter.handleProblems(found);
        };
    }

    @Override
    protected Option findOptionByName(String arg) {
        try {
            return ValidateOption.byName(arg);
        }
        catch (NoSuchElementException e) {
            return super.findOptionByName(arg);
        }
    }

    @Override
    protected void processNonOptionArguments(List<String> args) {
        List<Object> tyepd = args.stream().map(arg -> {
            try {
                return ValidateOption.INSTANCE.getTypedArgument((String)arg);
            }
            catch (IllegalArgumentException e) {
                throw new CommandException(Message.OPTION_ARGUMENT_INVALID, ValidateOption.INSTANCE, arg);
            }
        }).collect(Collectors.toList());
        this.addOption(ValidateOption.INSTANCE, tyepd);
    }

    @Override
    protected Set<? extends Option> getRequiredOptions() {
        return EnumSet.of(ValidateOption.SCHEMA);
    }

    private class Catalog
    extends SchemaCatalog {
        private static final long serialVersionUID = 1L;

        private Catalog() {
        }

        @Override
        protected JsonSchema readReferencedSchema(Location location) {
            Validate.this.console.print(Message.VALIDATE_REFERENCED_SCHEMA, location);
            return Validate.this.validateSchemaAt(location);
        }
    }
}

