/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.leadpony.justify.cli.Location;
import org.leadpony.justify.cli.Option;

enum ValidateOption implements Option
{
    HELP("-h"),
    SCHEMA("-s"),
    INSTANCE("-i"),
    REFERENCE("-r"),
    CATALOG("-catalog"),
    STRICT("-strict");

    private final String[] names;
    private static final Map<String, ValidateOption> OPTIONS;

    private ValidateOption(String ... names) {
        this.names = names;
    }

    @Override
    public boolean isRequired() {
        return this == SCHEMA;
    }

    @Override
    public String preferredName() {
        return this.names[0];
    }

    @Override
    public boolean requiresArgument() {
        switch (this) {
            case SCHEMA: 
            case INSTANCE: 
            case REFERENCE: 
            case CATALOG: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean takesMultipleArguments() {
        switch (this) {
            case INSTANCE: 
            case REFERENCE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getTypedArgument(String string) {
        switch (this) {
            case SCHEMA: 
            case INSTANCE: 
            case REFERENCE: 
            case CATALOG: {
                return Location.at(string);
            }
        }
        return string;
    }

    static ValidateOption byName(String name) {
        if (OPTIONS.containsKey(name)) {
            return OPTIONS.get(name);
        }
        throw new NoSuchElementException();
    }

    static {
        OPTIONS = new HashMap<String, ValidateOption>();
        for (ValidateOption value : ValidateOption.values()) {
            for (String name : value.names) {
                OPTIONS.put(name, value);
            }
        }
    }
}

