/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaResolver;
import org.leadpony.justify.cli.Location;

abstract class SchemaCatalog
extends HashMap<URI, Location>
implements JsonSchemaResolver {
    private static final long serialVersionUID = 1L;
    private final Map<URI, JsonSchema> cache = new HashMap<URI, JsonSchema>();

    SchemaCatalog() {
    }

    public JsonSchema resolveSchema(URI id) {
        String fragment = id.getFragment();
        URI baseId = SchemaCatalog.withoutFragment(id);
        JsonSchema schema = this.findRootSchema(baseId);
        if (schema == null) {
            return null;
        }
        if (fragment == null) {
            return schema;
        }
        return schema.getSubschemaAt(fragment);
    }

    private JsonSchema findRootSchema(URI id) {
        JsonSchema schema = this.cache.get(id);
        if (schema != null) {
            return schema;
        }
        Location resource = (Location)this.get(id);
        if (resource == null) {
            return null;
        }
        schema = this.readReferencedSchema(resource);
        if (schema != null) {
            this.cache.put(id, schema);
            return schema;
        }
        return null;
    }

    private static URI withoutFragment(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    protected abstract JsonSchema readReferencedSchema(Location var1);
}

