/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.cli.Command;
import org.leadpony.justify.cli.CommandException;
import org.leadpony.justify.cli.Console;
import org.leadpony.justify.cli.Message;
import org.leadpony.justify.cli.Option;
import org.leadpony.justify.cli.Status;

abstract class AbstractCommand
implements Command {
    protected final Console console;
    private final Map<Option, List<Object>> options = new HashMap<Option, List<Object>>();
    private Status status = Status.VALID;

    protected AbstractCommand(Console console) {
        this.console = console;
    }

    Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    boolean containsOption(Option option) {
        return this.options.containsKey(option);
    }

    Object getOptionValue(Option option) {
        List<?> values = this.getOptionValues(option);
        return values.isEmpty() ? null : values.get(0);
    }

    List<?> getOptionValues(Option option) {
        if (this.options.containsKey(option)) {
            return this.options.get(option);
        }
        return Collections.emptyList();
    }

    protected void parseCommandArguments(List<String> args) {
        ArrayList<String> nonOptionArgs = new ArrayList<String>();
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.startsWith("-")) {
                this.parseOption(arg, args);
                continue;
            }
            nonOptionArgs.add(arg);
        }
        if (!nonOptionArgs.isEmpty()) {
            this.processNonOptionArguments(nonOptionArgs);
        }
        this.checkRequiredOptions();
    }

    protected void addOption(Option option) {
        this.options.put(option, Collections.emptyList());
    }

    protected void addOption(Option option, List<Object> args) {
        if (this.options.containsKey(option)) {
            this.options.get(option).addAll(args);
        } else {
            this.options.put(option, args);
        }
    }

    private void parseOption(String arg, List<String> remaining) {
        Option option = this.findOptionByName(arg);
        if (option.requiresArgument()) {
            if (remaining.isEmpty() || remaining.get(0).startsWith("-")) {
                throw new CommandException(Message.OPTION_ARGUMENT_MISSING, arg);
            }
            this.addOption(option, this.parseOptionArguments(option, remaining));
        } else {
            this.addOption(option);
        }
    }

    private List<Object> parseOptionArguments(Option option, List<String> remaining) {
        String arg;
        ArrayList<Object> args = new ArrayList<Object>();
        while (!remaining.isEmpty() && !(arg = remaining.get(0)).startsWith("-")) {
            remaining.remove(0);
            try {
                args.add(option.getTypedArgument(arg));
            }
            catch (IllegalArgumentException e) {
                throw new CommandException(Message.OPTION_ARGUMENT_INVALID, option.preferredName(), arg);
            }
            if (option.takesMultipleArguments()) continue;
            break;
        }
        return args;
    }

    private void checkRequiredOptions() {
        for (Option option : this.getRequiredOptions()) {
            if (this.options.containsKey(option)) continue;
            throw new CommandException(Message.OPTION_MISSING, option.preferredName());
        }
    }

    protected Option findOptionByName(String arg) {
        throw new CommandException(Message.OPTION_UNRECOGNIZED, arg);
    }

    protected void processNonOptionArguments(List<String> args) {
    }

    protected Set<? extends Option> getRequiredOptions() {
        return Collections.emptySet();
    }
}

